
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data to plot
labels = ["Wheat", "Rice", "Corn", "Barley", "Soybeans"]
sizes = [30, 20, 25, 10, 15]

explode = (0.1, 0, 0, 0, 0.1)  # Highlight the largest and smallest segments

# Extracted variables
plot_title = "Crop Distribution in Agricultural Sector"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#4F81BD", "#C0504D", "#9BBB59", "#8064A2", "#4BACC6"]  # Health-related calm colors
autopct_format = "%1.1f%%"
shadow_option = True
start_angle = 90
legend_location = "upper right"
legend_fontsize = 10
title_fontsize = 16
title_y_position = 1.05

# Plot
plt.figure(figsize=(8, 6))
plt.pie(
    sizes,
    explode=explode,
    colors=colors,
    autopct=autopct_format,
    shadow=shadow_option,
    startangle=start_angle,
)
plt.axis("equal")

# Add legend
plt.legend(labels, loc=legend_location, fontsize=legend_fontsize)
plt.title(plot_title, fontsize=title_fontsize, y=title_y_position)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("pie_78.pdf", bbox_inches="tight")
