
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Define the vector field function
def sports_vector_field(X, Y):
    # Simulated player dynamics in sports
    U = np.cos(Y)
    V = np.sin(X)
    return U, V

# Create a grid of points
x = np.linspace(-2.0, 2.0, 20)
y = np.linspace(-2.0, 2.0, 20)
X, Y = np.meshgrid(x, y)

# Compute the vector field
U, V = sports_vector_field(X, Y)

# Text label parameters
xlabel = "Field Length"
ylabel = "Field Width"
title = "Sports Dynamics: Player Movements"
labels = ["Player A", "Player B", "Player C"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(6, 5))
ax.quiver(X, Y, U, V, color="#0b3d91", scale=50)

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title, fontsize=14)

# Show grid
ax.grid(True, linestyle="--", alpha=0.6)

# Annotations
ax.text(0.5, 0.5, labels[0], fontsize=10, color="black")
ax.text(1.5, 1.5, labels[1], fontsize=10, color="red")
ax.text(-1.5, -1.5, labels[2], fontsize=10, color="blue")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and display the plot
plt.tight_layout()
plt.savefig("quiver_31.pdf", bbox_inches="tight")

