
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Define the vector field function to simulate population movement
def population_vector_field(X, Y):
    U = np.sin(Y) - np.cos(X)
    V = np.cos(Y) + np.sin(X)
    return U, V

# Create a grid of points
x = np.linspace(-90, 90, 20)  # Latitude range
y = np.linspace(-180, 180, 20)  # Longitude range
X, Y = np.meshgrid(x, y)

# Compute the vector field
U, V = population_vector_field(X, Y)
xlabel = "Latitude"
ylabel = "Longitude"
title = "Population Movement Vector Field"
cbarlabel="Magnitude"
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(8, 6))
vector_color = "#ff6347"  # Tomato color for vectors

ax.quiver(X, Y, U, V, color=vector_color)

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Show grid
ax.grid(True, linestyle="--", alpha=0.7)

# Use a colormap to represent different vector magnitudes
magnitude = np.sqrt(U**2 + V**2)
quiver_cmap = "coolwarm"
ax.quiver(X, Y, U, V, magnitude, cmap=quiver_cmap)

# Add a color bar to represent the magnitude
cbar = plt.colorbar(ax.quiver(X, Y, U, V, magnitude, cmap=quiver_cmap), ax=ax)
cbar.set_label(cbarlabel)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and display the plot
plt.tight_layout()
plt.savefig("quiver_32.pdf", bbox_inches="tight")
