# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.lines as mlines
import matplotlib.patches as mpatches

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)


# Define the vector field function
def vector_field(X, Y):
    U = -Y
    V = X
    return U, V


def modified_vector_field(X, Y):
    U = -1 - X**2 + Y
    V = 1 + X - Y**2
    return U, V


def additional_vector_field(X, Y):
    U = -1.5 - X**1.5 + Y
    V = 1.5 + X - Y**1.5
    return U, V


# Create a grid of points
x = np.linspace(0, 1.2, 10)
y = np.linspace(0, 1.2, 10)
X, Y = np.meshgrid(x, y)

# Compute the vector fields
U, V = vector_field(X, Y)
U_mod, V_mod = modified_vector_field(X, Y)
U_add, V_add = additional_vector_field(X, Y)

# Plot additional curves
x = np.linspace(0.2, 0.5, 100)
xlabel = "Historical Data Age"
ylabel = "Impact Measure"
patch_labels = ["Historical Influence", "Modern Influence", "Future Prediction"]
line_labels = ["Ancient Data Analysis", "Medieval Data Analysis", "Modern Analysis", "Predictive Model 1", "Predictive Model 2"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(12, 9))
plt.quiver(X, Y, U, V, color="#1abc9c", alpha=0.6)
plt.quiver(X, Y, U_mod, V_mod, color="#f39c12", alpha=0.6)
plt.quiver(X, Y, U_add, V_add, color="#e74c3c", alpha=0.6)

# Adjust the curves to ensure y values do not exceed 1.0
plt.plot(x, np.minimum(0.09 / (x**1.2), 1.0), color="#9b59b6", linestyle="-", linewidth=2)
plt.plot(x, np.minimum(0.08 / (x**1.2 + 0.04), 1.0), color="#2980b9", linestyle="--", linewidth=2)
plt.plot(x, np.minimum(0.075 / (x**1 + 0.04), 1.0), color="#2ecc71", linestyle="-.", linewidth=2)
plt.plot(x, np.minimum(0.12 / (x**1 + 0.05), 1.0), color="#34495e", linestyle=":", linewidth=2)
plt.plot(x, np.minimum(0.1 / (x**0.9 + 0.03), 1.0), color="#d35400", linestyle="-.", linewidth=2)

# Add labels and legend
plt.xlabel(xlabel, fontsize=16, style="italic")
plt.ylabel(ylabel, fontsize=16, style="italic")

red_patch = mpatches.Patch(color="#1abc9c", label=patch_labels[0], alpha=0.6)
orange_patch = mpatches.Patch(color="#f39c12", label=patch_labels[1], alpha=0.6)
blue_patch = mpatches.Patch(color="#e74c3c", label=patch_labels[2], alpha=0.6)

# Create legend for curves
sample1_line = mlines.Line2D(
    [], [], color="#9b59b6", label=line_labels[0], linestyle="-"
)
sample2_line = mlines.Line2D(
    [], [], color="#2980b9", label=line_labels[1], linestyle="--"
)
model1_line = mlines.Line2D(
    [], [], color="#2ecc71", label=line_labels[2], linestyle="-."
)
model2_line = mlines.Line2D(
    [], [], color="#34495e", label=line_labels[3], linestyle=":"
)
model3_line = mlines.Line2D(
    [], [], color="#d35400", label=line_labels[4], linestyle="-."
)

# Combine all legend handles
handles = [
    red_patch,
    orange_patch,
    blue_patch,
    sample1_line,
    sample2_line,
    model1_line,
    model2_line,
    model3_line,
]

# Add the legend to the plot with specified location
plt.legend(handles=handles, loc="upper right")

# Set y-axis limit to 1.0
plt.ylim(0, 1.0)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("quiver_49.pdf", bbox_inches="tight")
