
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Define the wind field function for an amusement ride (e.g., roller coaster)
def ride_wind_field(X, Y):
    # This simulates wind patterns around a roller coaster track area
    U = np.cos(np.pi * X / 30) * np.sin(np.pi * Y / 30)
    V = -np.sin(np.pi * X / 30) * np.cos(np.pi * Y / 30)
    return U, V

# Create a grid of points
x = np.linspace(-40.0, 40.0, 25)
y = np.linspace(-40.0, 40.0, 25)
X, Y = np.meshgrid(x, y)

# Compute the wind field
U, V = ride_wind_field(X, Y)

# Set labels and title for the amusement ride
xlabel = "Track X Coordinate (m)"
ylabel = "Track Y Coordinate (m)"
title = "Wind Patterns Around Roller Coaster Track"

suptitle = "Roller Coaster Wind Analysis"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(8, 7))
ax.quiver(X, Y, U, V, color="mediumvioletred", scale=30, width=0.003)

# Set labels and title
ax.set_xlabel(xlabel, fontsize=14)
ax.set_ylabel(ylabel, fontsize=14)
ax.set_title(title, fontsize=16, fontweight="bold")

# Set background color and grid
ax.set_facecolor("lemonchiffon")  # light yellow background
ax.grid(True, linestyle="--", alpha=0.6)

# Improve overall layout and aesthetics
fig.suptitle(suptitle, fontsize=18, fontweight="bold")
fig.subplots_adjust(top=0.88)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and display the plot
plt.tight_layout()
plt.savefig("quiver_56.pdf", bbox_inches="tight")
