

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

def media_influence_vector_field(X, Y):
    # Simulating media influence where central regions broadcast stronger influence
    U = -0.3 * X  # Simplified arbitrary functions
    V = 0.3 * Y
    return U, V

# Create a grid of points
x = np.linspace(-20.0, 20.0, 30)
y = np.linspace(-20.0, 20.0, 30)
X, Y = np.meshgrid(x, y)

# Compute the vector field for media influences
U, V = media_influence_vector_field(X, Y)
magnitude = np.sqrt(U**2 + V**2)

xlabel = "Region X"
ylabel = "Region Y"
title = "Media Influence Vector Field"
cbar_label = "Influence Magnitude"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(10, 8))
quiver = ax.quiver(X, Y, U, V, magnitude, cmap="RdYlGn", scale=15)

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Show grid
ax.grid(True, linestyle="--", alpha=0.5)

# Add color bar to show magnitude
cbar = plt.colorbar(quiver, ax=ax)
cbar.set_label(cbar_label)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("quiver_60.pdf", bbox_inches="tight")
