

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

def engagement_field(X, Y):
    # Simulating vectors for audience engagement
    U = np.sin(X / 8) * np.cos(Y / 8)
    V = np.cos(X / 8) * np.sin(Y / 8)
    return U, V

# Create a grid of points representing theater sections and rows
x = np.linspace(-25.0, 25.0, 15)
y = np.linspace(-20.0, 20.0, 15)
X, Y = np.meshgrid(x, y)

# Compute the vector field for engagement directions
U, V = engagement_field(X, Y)
magnitude = np.sqrt(U**2 + V**2)

xlabel = "Theater Sections (Width)"
ylabel = "Rows (Front to Back)"
title = "Audience Engagement Intensity and Direction in a Theater"
cbar_label = "Engagement Intensity (units)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(10, 8))
quiver = ax.quiver(X, Y, U, V, magnitude, cmap="viridis", scale=4)

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title, fontsize=16, fontweight='bold')

# Show grid
ax.grid(True, linestyle="--", alpha=0.7)

# Add color bar to show magnitude
cbar = plt.colorbar(quiver, ax=ax)
cbar.set_label(cbar_label, fontsize=12, fontweight='bold')

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and display the plot
plt.tight_layout()
plt.savefig("quiver_62.pdf", bbox_inches="tight")
