

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Define the vector field function for airflow dynamics
def airflow_vector_field(X, Y):
    U = np.sin(2 * np.pi * X / 50) * np.cos(np.pi * Y / 50)
    V = np.cos(np.pi * X / 50) * np.sin(2 * np.pi * Y / 50)
    return U, V

# Create a grid of points
x = np.linspace(-25.0, 25.0, 30)
y = np.linspace(-25.0, 25.0, 30)
X, Y = np.meshgrid(x, y)

# Compute the vector field for airflow dynamics
U, V = airflow_vector_field(X, Y)
speed = np.sqrt(U**2 + V**2)

xlabel = "Wing X Coordinate"
ylabel = "Wing Y Coordinate"
title = "Simulated Airflow over an Airfoil"
cbar_label = "Airflow Speed"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(10, 7))
Q = ax.quiver(X, Y, U, V, speed, cmap="coolwarm", alpha=0.9)

# Set labels and title
ax.set_xlabel(xlabel, fontsize=12, fontweight='bold')
ax.set_ylabel(ylabel, fontsize=12, fontweight='bold')
ax.set_title(title, fontsize=14, fontweight='bold')

# Show grid
ax.grid(True, linestyle="-", alpha=0.7)

# Add a color bar
cbar = fig.colorbar(Q, ax=ax)
cbar.set_label(cbar_label, fontsize=12, fontweight='bold')

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and display the plot
plt.tight_layout()
plt.savefig("quiver_64.pdf", bbox_inches="tight")

