
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Define a vector field function that represents wind patterns
def vector_field(X, Y):
    # Example function to mimic wind patterns
    U = np.sin(X / 10) * np.cos(Y / 10)
    V = np.cos(X / 10) * np.sin(Y / 10)
    return U, V

# Create a grid of points representing the geographical region
x = np.linspace(-100.0, 100.0, 20)
y = np.linspace(-100.0, 100.0, 20)
X, Y = np.meshgrid(x, y)

# Compute the vector field
U, V = vector_field(X, Y)
xlabel = "Longitude (degrees)"
ylabel = "Latitude (degrees)"
title = "Wind Patterns Over Geographical Region"
colorbar_title = "Wind Speed (m/s)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(8, 6))

# Use colors to represent the strength of the wind speed
colors = np.sqrt(U**2 + V**2)
quiver = ax.quiver(X, Y, U, V, colors, cmap="cool")

# Add the color bar
cbar = fig.colorbar(quiver, ax=ax)
cbar.set_label(colorbar_title)

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Show grid
ax.grid(True, linestyle="--", alpha=0.7)

# Adjust the aspect ratio to be equal for correct geographical representation
ax.set_aspect("equal")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing
plt.tight_layout()

# Save and display the plot
plt.savefig("quiver_69.pdf", bbox_inches="tight")
