
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Define a vector field function that represents the spread of a religious message
def vector_field(X, Y):
    # Example function to mimic the spread of influence
    U = np.sin(X / 10.0) * np.cos(Y / 10.0)
    V = -np.cos(X / 10.0) * np.sin(Y / 10.0)
    return U, V

# Create a grid of points
x = np.linspace(-50.0, 50.0, 20)
y = np.linspace(-50.0, 50.0, 20)
X, Y = np.meshgrid(x, y)

# Compute the vector field
U, V = vector_field(X, Y)
xlabel = "Longitude (degrees)"
ylabel = "Latitude (degrees)"
title = "Spread of Religious Message Vector Field"
colorbar_title = "Spread Intensity (arbitrary units)"
labels = ["Church", "Mosque", "Temple"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(8, 6))

# Use colors to represent the strength of the movement
colors = np.sqrt(U**2 + V**2)
quiver = ax.quiver(X, Y, U, V, colors, cmap="cool")

# Add annotations for key points of interest
points_of_interest = [(-30, -30), (30, 30), (0, 0)]
for point, label in zip(points_of_interest, labels):
    ax.text(point[0], point[1], label, fontsize=12, ha="right")

# Add the color bar
cbar = fig.colorbar(quiver, ax=ax)
cbar.set_label(colorbar_title)

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Show grid
ax.grid(True, linestyle="--", alpha=0.7)

# Adjust the aspect ratio to be equal for correct geographical representation
ax.set_aspect("equal")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing
plt.tight_layout()

# Save and display the plot
plt.savefig("quiver_71.pdf", bbox_inches="tight")
