

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(78)  # Changed seed for new data generation

def tourist_movements(X, Y):
    # Simulating tourist movement pattern
    U = np.cos(Y / 2) - np.sin(X / 3)
    V = np.sin(X / 3) + np.cos(Y / 2)
    return U, V

# Create a grid of points
x = np.linspace(-3.0, 3.0, 18)  # Changed grid size and limits for a city map
y = np.linspace(-3.0, 3.0, 18)
X, Y = np.meshgrid(x, y)

# Compute the tourist movement vector field
U, V = tourist_movements(X, Y)
magnitude = np.sqrt(U**2 + V**2)

xlabel = "City X Coordinate"
ylabel = "City Y Coordinate"
title = "Simulated Tourist Movement"
colorbar_title = "Movement Magnitude (arbitrary units)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(10, 8))
quiver = ax.quiver(X, Y, U, V, magnitude, cmap="ocean", scale=5, headwidth=3, headlength=4)

# Set labels and title
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_title(title, fontsize=16, weight='bold')

# Show grid with urban style
ax.grid(True, linestyle="--", alpha=0.5, color='grey')

# Add color bar to show magnitude
cbar = plt.colorbar(quiver, ax=ax)
cbar.set_label(colorbar_title, fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and display the plot
plt.tight_layout()
plt.savefig("quiver_78.pdf", bbox_inches="tight")

