
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.lines import Line2D

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Domain-specific data: Performance Metrics for two fictional marketing campaigns
values_campaign_a = [7.5, 8.0, 6.5, 9.0, 7.0, 8.5]
values_campaign_b = [8.0, 7.0, 7.5, 6.0, 8.5, 7.5]
num_vars = len(values_campaign_a)
labels = ["Campaign A", "Campaign B"]
metric_labels = ["Engagement", "Reach", "Conversion", "Cost", "Time Efficiency", "Satisfaction"]
ticks = [2, 4, 6, 8, 10]
tickslabel = ["2", "4", "6", "8", "10"]
title = "Performance Metrics of Marketing Campaigns"

# Extend data to close the radar chart loop
values_campaign_a += values_campaign_a[:1]
values_campaign_b += values_campaign_b[:1]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Color Variables
color_a = "blue"
color_b = "green"

# Compute angle for each axis
angles = np.linspace(0, 2 * np.pi, num_vars, endpoint=False).tolist()
angles += angles[:1]

# Draw the radar chart
fig, ax = plt.subplots(figsize=(8, 8), subplot_kw=dict(polar=True))

# Fill and plot Campaign A's performance
ax.fill(angles, values_campaign_a, color=color_a, alpha=0.1)
ax.plot(angles, values_campaign_a, color=color_a, linewidth=2, linestyle='solid', label=labels[0])
ax.scatter(angles[:-1], values_campaign_a[:-1], color=color_a, s=50, marker='o')

# Fill and plot Campaign B's performance
ax.fill(angles, values_campaign_b, color=color_b, alpha=0.1)
ax.plot(angles, values_campaign_b, color=color_b, linewidth=2, linestyle='dashed', label=labels[1])
ax.scatter(angles[:-1], values_campaign_b[:-1], color=color_b, s=50, marker='s')

# Add labels to the plot
ax.set_yticklabels([])
ax.set_xticks(angles[:-1])
ax.set_xticklabels(metric_labels, size=12, color="gray")

# Add grid lines and labels for the concentric circles
ax.set_rgrids(
    ticks,
    labels=tickslabel,
    angle=30,
    color="gray",
    size=10,
)

# Create legend handles manually
legend_elements = [
    Line2D([0], [0], color=color_a, linewidth=2, linestyle='solid', marker='o', markersize=8, label=labels[0]),
    Line2D([0], [0], color=color_b, linewidth=2, linestyle='dashed', marker='s', markersize=8, label=labels[1]),
]

# Add legend and title
ax.legend(handles=legend_elements, loc="upper right", bbox_to_anchor=(1.1, 1.1), frameon=False)
ax.set_title(title, size=16, color="black", pad=20)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("radar_27.pdf", bbox_inches="tight")
