
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt
from math import pi

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Define the data for each performance category in art and design
values_team_A = [0.85, 0.78, 0.92, 0.81, 0.88, 0.89]
values_team_B = [0.82, 0.77, 0.89, 0.79, 0.84, 0.87]
values_team_C = [0.80, 0.75, 0.91, 0.76, 0.83, 0.86]
values_team_D = [0.87, 0.80, 0.94, 0.82, 0.89, 0.91]
xtickslabel = ["Creativity", "Technical Skill", "Conceptual Thinking", "Execution", "Collaboration", "Adaptability"]
y_ticks = [0.6, 0.7, 0.8, 0.9, 1.0]
labels = ["Artist A", "Artist B", "Artist C", "Artist D"]
ylim = [0.6, 1.0]

# Plot title
plot_title = "Performance Scores in Different Art and Design Categories"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set up the figure and polar axis
fig, ax = plt.subplots(figsize=(8, 8), subplot_kw=dict(polar=True))

# Number of variables
num_vars = len(values_team_A)
# Compute angle for each axis
angles = [n / float(num_vars) * 2 * pi for n in range(num_vars)]
angles += angles[:1]  # Complete the loop

# Repeat the first value to close the circle
values_team_A += values_team_A[:1]
values_team_B += values_team_B[:1]
values_team_C += values_team_C[:1]
values_team_D += values_team_D[:1]

# Draw one axe per variable and add labels
plt.xticks(
    angles[:-1],
    xtickslabel,
    color="black",
    size=10,
)
    
# Draw ylabels
def add_custom_y_labels(ax, angles, labels, distance, size=8):
    for angle, label in zip(angles, labels):
        ax.text(
            angle,
            distance,
            label,
            horizontalalignment="center",
            size=size,
            verticalalignment="bottom",
        )

# Define the range of y-axis and y-labels
plt.yticks(y_ticks, [str(i) for i in y_ticks], color="black", size=8)

# Set y-axis limit
plt.ylim(ylim)

# Plot data and fill area for each line with customized styles
ax.plot(
    angles,
    values_team_A,
    linewidth=2,
    linestyle="dashed",
    label=labels[0],
    color="#1f77b4",
    marker="o",
    markersize=5
)
ax.fill(angles, values_team_A, "#1f77b4", alpha=0.15)

ax.plot(
    angles,
    values_team_B,
    linewidth=2,
    linestyle="dotted",
    label=labels[1],
    color="#ff7f0e",
    marker="s",
    markersize=5
)
ax.fill(angles, values_team_B, "#ff7f0e", alpha=0.15)

ax.plot(
    angles,
    values_team_C,
    linewidth=2,
    linestyle="dashdot",
    label=labels[2],
    color="#2ca02c",
    marker="^",
    markersize=5
)
ax.fill(angles, values_team_C, "#2ca02c", alpha=0.15)

ax.plot(
    angles,
    values_team_D,
    linewidth=2,
    linestyle="solid",
    label=labels[3],
    color="#d62728",
    marker="v",
    markersize=5
)
ax.fill(angles, values_team_D, "#d62728", alpha=0.15)

# Add legend with a different style
plt.legend(loc="upper right", bbox_to_anchor=(1.1, 1.1), ncol=1, fontsize='small')

# Add a title
plt.title(plot_title, size=15, color="black", pad=20)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better fit and save the plot
plt.tight_layout()
plt.savefig("radar_36.pdf", bbox_inches="tight")
