
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from math import pi

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Define the data for each line
labels = np.array(
    [
        "GDP Growth",
        "Inflation Rate",
        "Unemployment Rate",
        "Interest Rate",
        "Consumer Confidence",
        "Exports",
        "Imports",
        "Fiscal Policy",
        "Monetary Policy",
        "Foreign Investment",
        "Savings Rate",
        "Debt-to-GDP Ratio",
    ]
)
num_vars = len(labels)

# Fictional scores for three economic teams
values1 = np.array([3.2, 4.1, 3.5, 4.3, 4.6, 4.8, 4.1, 3.7, 4.0, 3.9, 4.2, 4.4])
values2 = np.array([3.8, 3.7, 4.0, 3.9, 4.3, 4.2, 4.6, 4.1, 3.8, 4.0, 3.9, 3.7])
values3 = np.array([4.0, 3.5, 4.2, 3.7, 3.6, 4.1, 4.0, 3.8, 3.9, 4.4, 3.8, 3.5])

labels2 = ["EcoTeam Alpha", "Finance Squad", "Econ Mavericks"]
yticks = [1, 2, 3, 4, 5]
ytickslabel = ["1", "2", "3", "4", "5"]
ylim = [0, 5]

title = "Performance Ratings of Economic Teams Across Different Indicators"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(figsize=(8, 8), subplot_kw=dict(polar=True))

# Colors
color1 = "#1f77b4"
color2 = "#ff7f0e"
color3 = "#2ca02c"

# Compute angle for each axis
angles = [n / float(num_vars) * 2 * pi for n in range(num_vars)]
values1 = np.concatenate((values1, [values1[0]]))
values2 = np.concatenate((values2, [values2[0]]))
values3 = np.concatenate((values3, [values3[0]]))
angles += angles[:1]

# Draw one axe per variable and add labels
plt.xticks(angles[:-1], labels, color="navy", size=10)

# Draw ylabels
ax.set_rlabel_position(0)
plt.yticks(yticks, ytickslabel, color="grey", size=8)
plt.ylim(ylim)

# Plot data
ax.plot(
    angles,
    values1,
    linewidth=2,
    linestyle="solid",
    label=labels2[0],
    color=color1,
    marker="o",
)
ax.fill(angles, values1, color1, alpha=0.25)

ax.plot(
    angles,
    values2,
    linewidth=2,
    linestyle="dashed",
    label=labels2[1],
    color=color2,
    marker="s",
)
ax.fill(angles, values2, color2, alpha=0.25)

ax.plot(
    angles,
    values3,
    linewidth=2,
    linestyle="dotted",
    label=labels2[2],
    color=color3,
    marker="D",
)
ax.fill(angles, values3, color3, alpha=0.25)

# Add legend
plt.legend(loc="lower left", bbox_to_anchor=(-0.15, -0.1), fontsize="small")

# Add title
plt.title(title, size=15, color="darkblue", y=1.1)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better fit and save the plot
plt.tight_layout()
plt.savefig("radar_40.pdf", bbox_inches="tight")
