
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt
from math import pi

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Define the data for the radar chart
categories = [
    "Self-Esteem",
    "Optimism",
    "Resilience",
    "Mindfulness",
    "Empathy",
    "Assertiveness",
    "Emotional Regulation",
]
values1 = [6.5, 7.8, 5.7, 8.0, 7.2, 6.9, 7.5]  # Values for Person A
values2 = [7.3, 6.2, 8.1, 7.5, 6.8, 8.0, 7.0]  # Values for Person B

# Number of variables
N = len(categories)

# Compute angle for each category
angles = [n / float(N) * 2 * pi for n in range(N)]
values1 += values1[:1]
values2 += values2[:1]
angles += angles[:1]

# Extracted variables
line_label1 = "Person A"
line_label2 = "Person B"
xticks = angles[:-1]
xtickslabel = categories
yticks = [0, 2, 4, 6, 8, 10]
ytickslabel = ["0", "2", "4", "6", "8", "10"]
ylim = (0, 10)
legend_loc = "lower center"
legend_bbox_to_anchor = (0.5, 1.2)
legend_ncol = 2
legend_frameon = False

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Initialize the spider plot
fig, ax = plt.subplots(figsize=(4, 4), subplot_kw=dict(polar=True))

# Draw one axe per variable and add labels with increased padding
plt.xticks(xticks, xtickslabel, color="black", size=10)

# Draw ylabels
ax.set_rlabel_position(0)
plt.yticks(yticks, ytickslabel, color="black", size=7)
plt.ylim(ylim)

# Plot data
ax.plot(
    angles, values1, linewidth=2, linestyle="solid", label=line_label1, color="#1f77b4"
)
ax.fill(angles, values1, "#1f77b4", alpha=0.3)

ax.plot(
    angles, values2, linewidth=2, linestyle="dashed", label=line_label2, color="#ff7f0e"
)
ax.fill(angles, values2, "#ff7f0e", alpha=0.3)

# Add legend
plt.legend(
    loc=legend_loc,
    bbox_to_anchor=legend_bbox_to_anchor,
    ncol=legend_ncol,
    frameon=legend_frameon,
)

# Set the background color inside the radar chart to white
ax.set_facecolor("white")

ax.xaxis.set_tick_params(pad=25)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better fit
plt.tight_layout()

# Show the plot
plt.savefig("radar_52.pdf", bbox_inches="tight")
