

# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
# Data for the radar chart
labels = np.array(
    [
        "Performance",
        "Battery Life",
        "Display Quality",
        "Camera",
        "Build Quality",
        "Software",
        "Value for Money",
        "Customer Support",
    ]
)
stats_product_x = np.random.rand(8)
stats_product_y = np.random.rand(8)
xticks = [0.2, 0.4, 0.6, 0.8, 1.0]
xtickslabel = ["0.2", "0.4", "0.6", "0.8", "1.0"]
label_x = "Product X"
label_y = "Product Y"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(6, 6), subplot_kw=dict(polar=True))

# Number of variables
num_vars = len(labels)

# Compute angle for each axis
angles = np.linspace(0, 2 * np.pi, num_vars, endpoint=False).tolist()

# The plot is circular, so we need to "complete the loop" and append the start to the end.
stats_product_x = np.concatenate((stats_product_x, [stats_product_x[0]]))
stats_product_y = np.concatenate((stats_product_y, [stats_product_y[0]]))
angles += angles[:1]

# Draw one axe per variable and add labels
plt.xticks(angles[:-1], labels, color="black", size=10)
ax.tick_params(pad=20)  # Increase the distance of the label from the axis

# Draw ylabels
ax.set_rscale("linear")
plt.yticks(xticks, xtickslabel, color="grey", size=7)
plt.ylim(0, 1)

# Plot data for Product X
ax.plot(
    angles,
    stats_product_x,
    linewidth=2,
    linestyle="solid",
    label=label_x,
    marker="o",
    color="#1f78b4",
)
# Plot data for Product Y
ax.plot(
    angles,
    stats_product_y,
    linewidth=2,
    linestyle="--",
    label=label_y,
    marker="s",
    color="#33a02c",
)

# Add legend
plt.legend(loc="lower center", bbox_to_anchor=(0.5, -0.2), ncol=2)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better fit and save the plot
plt.tight_layout()
plt.savefig("radar_57.pdf", bbox_inches="tight")

