

# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Simulate the psychological performance metrics data
labels = np.array(
    [
        "Cognitive Skills",
        "Emotional Stability",
        "Social Skills",
        "Memory",
        "Attention",
        "Problem Solving",
        "Creativity",
    ]
)
stats_group_x = np.array([4.5, 3.8, 4.2, 4.0, 3.9, 4.4, 4.1])
stats_group_y = np.array([3.9, 4.0, 3.8, 4.5, 4.2, 4.0, 3.7])
xticks = [1, 2, 3, 4, 5]
xtickslabel = ["1", "2", "3", "4", "5"]
label_x = "Group X"
label_y = "Group Y"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(6, 6), subplot_kw=dict(polar=True))

# Number of variables
num_vars = len(labels)

# Compute angle for each axis
angles = np.linspace(0, 2 * np.pi, num_vars, endpoint=False).tolist()

# The plot is circular, so we need to "complete the loop" and append the start to the end.
stats_group_x = np.concatenate((stats_group_x, [stats_group_x[0]]))
stats_group_y = np.concatenate((stats_group_y, [stats_group_y[0]]))
angles += angles[:1]

# Draw one axe per variable and add labels
plt.xticks(angles[:-1], labels, color="black", size=10)
ax.tick_params(pad=20)  # Increase the distance of the label from the axis

# Draw ylabels
ax.set_rscale("linear")
plt.yticks(xticks, xtickslabel, color="grey", size=7)
plt.ylim(0, 5)

# Color configuration for plot data
color_x = "#1f77b4"
color_y = "#ff7f0e"

# Plot data for Group X
ax.plot(
    angles,
    stats_group_x,
    linewidth=2,
    linestyle="-",
    label=label_x,
    marker="o",
    color=color_x,
)

# Plot data for Group Y
ax.plot(
    angles,
    stats_group_y,
    linewidth=2,
    linestyle="--",
    label=label_y,
    marker="s",
    color=color_y,
)

# Add legend
plt.legend(loc="lower center", bbox_to_anchor=(0.5, -0.2), ncol=2)

# Add chart title
plt.title("Psychological Performance Metrics Comparison", size=14, color='black')

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better fit and save the plot
plt.tight_layout()
plt.savefig("radar_58.pdf", bbox_inches="tight")

