
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Labels for the new domain: Education
labels = np.array(
    ["Math", "Science", "Literature", "Art", "History", "Technology", "Physical Education", "Language"]
)
Edu_A = np.array([0.88, 0.74, 0.81, 0.68, 0.92, 0.79, 0.75, 0.84])
Edu_B = np.array([0.65, 0.72, 0.69, 0.76, 0.80, 0.85, 0.70, 0.78])
Edu_C = np.array([0.78, 0.67, 0.74, 0.83, 0.81, 0.73, 0.84, 0.76])
Edu_D = np.array([0.82, 0.88, 0.77, 0.91, 0.85, 0.80, 0.83, 0.87])
yticks = [0.2, 0.4, 0.6, 0.8]
legend_labels = ["Edu_A", "Edu_B", "Edu_C", "Edu_D"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(6, 6), subplot_kw=dict(polar=True))
# Number of variables
num_vars = len(labels)
# Compute angle for each axis
angles = np.linspace(0, 2 * np.pi, num_vars, endpoint=False).tolist()
# Complete the loop for radar chart continuity
Edu_A = np.concatenate((Edu_A, [Edu_A[0]]))
Edu_B = np.concatenate((Edu_B, [Edu_B[0]]))
Edu_C = np.concatenate((Edu_C, [Edu_C[0]]))
Edu_D = np.concatenate((Edu_D, [Edu_D[0]]))
angles += angles[:1]
# Draw axis per variable and add labels
plt.xticks(angles[:-1], labels, color="black", size=10)
ax.tick_params(pad=10)  # Increase distance of label from axis
# Draw ylabels
ax.set_rlabel_position(0)
plt.yticks(yticks, [], color="grey", size=7)
plt.ylim(0, 1)
# Plot data
ax.plot(
    angles,
    Edu_A,
    color="#FF6347",
    linewidth=2,
    linestyle="solid",
    label=legend_labels[0],
    marker="s",
)
ax.plot(
    angles,
    Edu_B,
    color="#4682B4",
    linewidth=2,
    linestyle="dashed",
    label=legend_labels[1],
    marker="^",
)
ax.plot(
    angles,
    Edu_C,
    color="#8A2BE2",
    linewidth=2,
    linestyle="dashdot",
    label=legend_labels[2],
    marker="o",
)
ax.plot(
    angles,
    Edu_D,
    color="#3CB371",
    linewidth=2,
    linestyle="dotted",
    label=legend_labels[3],
    marker="D",
)
# Add legend
plt.legend(loc="upper left", bbox_to_anchor=(1, 1))

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better fit and save the plot
plt.tight_layout()
plt.savefig("radar_61.pdf", bbox_inches="tight")
