
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data for each sector
labels = np.array([
    "Revenue Growth", 
    "Net Profit Margin",
    "Debt Ratio", 
    "Return on Equity",
    "Market Share",
    "Dividend Yield",
    "Price/Earnings Ratio",
    "Operating Cash Flow"
])
Technology = np.array([85, 55, 40, 75, 90, 20, 25, 95])
Healthcare = np.array([70, 65, 35, 60, 80, 25, 30, 85])
Financial_Services = np.array([65, 50, 60, 70, 55, 40, 20, 60])
Consumer_Goods = np.array([50, 45, 50, 55, 60, 35, 55, 50])
yticks = [20, 40, 60, 80]
labels2 = ["Technology", "Healthcare", "Financial Services", "Consumer Goods"]
title = "Comparison of Key Financial Metrics Across Sectors"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(6, 6), subplot_kw=dict(polar=True))

# Number of variables
num_vars = len(labels)

# Compute angle for each axis
angles = np.linspace(0, 2 * np.pi, num_vars, endpoint=False).tolist()

# The plot is made circular, so we need to complete the loop
Technology = np.concatenate((Technology, [Technology[0]]))
Healthcare = np.concatenate((Healthcare, [Healthcare[0]]))
Financial_Services = np.concatenate((Financial_Services, [Financial_Services[0]]))
Consumer_Goods = np.concatenate((Consumer_Goods, [Consumer_Goods[0]]))
angles += angles[:1]

# Draw one axe per variable and add labels
plt.xticks(angles[:-1], labels, color="black", size=10)
ax.tick_params(pad=10)  # Increase the distance of the label from the axis

# Draw ylabels
ax.set_rlabel_position(0)
plt.yticks(yticks, [], color="grey", size=7)
plt.ylim(0, 100)

# Colors for each sector
colors = ['#1f77b4', '#ff7f0e', '#2ca02c', '#d62728']

# Plot data
ax.plot(angles, Technology, color=colors[0], linewidth=2, linestyle="solid", label=labels2[0], marker="o")
ax.plot(angles, Healthcare, color=colors[1], linewidth=2, linestyle="dashdot", label=labels2[1], marker="s")
ax.plot(angles, Financial_Services, color=colors[2], linewidth=2, linestyle="dashed", label=labels2[2], marker="^")
ax.plot(angles, Consumer_Goods, color=colors[3], linewidth=2, linestyle="dotted", label=labels2[3], marker="D")

# Add legend
plt.legend(loc="lower center", bbox_to_anchor=(0.5, -0.3), ncol=4)

ax.xaxis.set_tick_params(pad=25)

# Chart title
plt.title(title, size=15, color="#333")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better fit and save the plot
plt.tight_layout()
plt.savefig("radar_62.pdf", bbox_inches="tight")
