
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(2)
# Data
categories = [
    "Streaming\nQuality",
    "Ticket\nSales",
    "User\nReviews",
    "Ad\nRevenue",
    "Subscription\nGrowth",
    "Content\nVariety",
    "Customer\nSupport",
    "Social\nMedia\nPresence",
    "Brand\nLoyalty",
]

values1 = [85, 78, 82, 88, 70, 90, 72, 80, 75]  # Region C
values2 = [78, 88, 75, 80, 85, 78, 85, 82, 78]  # Region D

# Number of variables
num_vars = len(categories)

# Compute angle for each category
angles = np.linspace(0, 2 * np.pi, num_vars, endpoint=False).tolist()

# The plot is circular, so we need to "complete the loop" and append the start to the end.
values1 += values1[:1]
values2 += values2[:1]
angles += angles[:1]

# Extracted variables
line_label1 = "Region C"
line_label2 = "Region D"
xticks_labels = categories
yticks_values = [20, 40, 60, 80]
yticks_labels = []
ylim_values = (0, 100)
title_text = "Entertainment Performance Indicators: Region C vs Region D"
title_size = 14
title_color = "darkgreen"
title_y = 1.1
legend_loc = "lower center"
legend_ncol = 2
legend_bbox_to_anchor = (0.5, -0.2)
legend_fontsize = "small"
legend_frameon = False

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Size of the figure
fig, ax = plt.subplots(figsize=(8, 8), subplot_kw=dict(polar=True))

# Draw one axe per variable and add labels, aligned vertically
plt.xticks(angles[:-1], xticks_labels, color="darkgreen", size=10, ha="center")

# Draw ylabels
ax.set_rlabel_position(0)
plt.yticks(yticks_values, yticks_labels, color="grey", size=7)
plt.ylim(ylim_values)

# Plot data with markers and new colors
ax.plot(
    angles,
    values2,
    linewidth=2,
    linestyle="dashed",
    marker="o",
    label=line_label2,
    color="#1f77b4",
)
ax.fill(angles, values2, "#1f77b4", alpha=0.2)

ax.plot(
    angles,
    values1,
    linewidth=2,
    linestyle="solid",
    marker="s",
    label=line_label1,
    color="#2ca02c",
)
ax.fill(angles, values1, "#2ca02c", alpha=0.2)

# Add a title to the radar chart
plt.title(title_text, size=title_size, color=title_color, y=title_y)

# Add legend
plt.legend(
    loc=legend_loc,
    ncol=legend_ncol,
    bbox_to_anchor=legend_bbox_to_anchor,
    fontsize=legend_fontsize,
    frameon=legend_frameon,
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("radar_63.pdf", bbox_inches="tight")
