

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data
categories = [
    "Air Quality",
    "Water Quality",
    "Biodiversity",
    "Renewable Energy Use",
    "Carbon Emissions",
    "Waste Recycling",
    "Forest Coverage",
    "Green Urban Spaces",
    "Transportation Sustainability",
]
values1 = [72, 85, 78, 90, 65, 80, 88, 70, 75]  # Country A
values2 = [80, 75, 88, 70, 55, 72, 82, 78, 65]  # Country B

# Number of variables
num_vars = len(categories)

# Compute angle for each category
angles = np.linspace(0, 2 * np.pi, num_vars, endpoint=False).tolist()

# The plot is circular, so we need to "complete the loop" and append the start to the end.
values1 += values1[:1]
values2 += values2[:1]
angles += angles[:1]

# Extracted variables
line_label1 = "Country A"
line_label2 = "Country B"
xticks_labels = categories
yticks_values = [20, 40, 60, 80]
yticks_labels = [str(value) for value in yticks_values]
ylim_values = (0, 100)
title_text = "Environmental Performance Comparison"
title_size = 16
title_color = "navy"
title_y = 1.1
legend_loc = "lower center"
legend_ncol = 2
legend_bbox_to_anchor = (0.5, -0.2)
legend_fontsize = "medium"
legend_frameon = True

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Size of the figure
fig, ax = plt.subplots(figsize=(8, 8), subplot_kw=dict(polar=True))

# Draw one axe per variable and add labels, aligned vertically
plt.xticks(angles[:-1], xticks_labels, color="darkblue", size=11, ha="center")

# Draw ylabels
ax.set_rlabel_position(0)
plt.yticks(yticks_values, yticks_labels, color="grey", size=8)
plt.ylim(ylim_values)

# Plot data with markers and new colors
ax.plot(
    angles,
    values2,
    linewidth=2,
    linestyle="dashed",
    marker="o",
    label=line_label2,
    color="#ff4500",
)
ax.fill(angles, values2, "#ff4500", alpha=0.25)

ax.plot(
    angles,
    values1,
    linewidth=2,
    linestyle="solid",
    marker="s",
    label=line_label1,
    color="#4682b4",
)
ax.fill(angles, values1, "#4682b4", alpha=0.25)

# Add a title to the radar chart
plt.title(title_text, size=title_size, color=title_color, y=title_y)

# Add legend
plt.legend(
    loc=legend_loc,
    ncol=legend_ncol,
    bbox_to_anchor=legend_bbox_to_anchor,
    fontsize=legend_fontsize,
    frameon=legend_frameon,
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("radar_64.pdf", bbox_inches="tight")

