
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from math import pi

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Define the data for each city
values1 = [12.5, 13.0, 14.0, 15.5, 16.0]  # City A
values2 = [8.0, 8.5, 9.0, 9.5, 10.0]  # City B
values3 = [25.0, 24.5, 24.0, 23.5, 23.0]  # City C
xtickslabel = ["2018", "2019", "2020", "2021", "2022"]
yticks = [5, 10, 15, 20, 25]
ytickslabel = ["5°C", "10°C", "15°C", "20°C", "25°C"]
ylim = [0, 30]
labels = ["City A", "City B", "City C"]

title = "Average Monthly Temperature in Different Cities"

# Number of variables
num_vars = len(values1)

# Compute angle for each axis
angles = [n / float(num_vars) * 2 * pi for n in range(num_vars)]
angles += angles[:1]  # Complete the loop

# Repeat the first value to close the circle
values1 += values1[:1]
values2 += values2[:1]
values3 += values3[:1]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Initialize the spider plot
fig, ax = plt.subplots(figsize=(8, 7), subplot_kw=dict(polar=True))

# Draw one axe per variable and add labels
plt.xticks(angles[:-1], xtickslabel, size=12)

# Draw ylabels
ax.set_rlabel_position(0)
plt.yticks(yticks, ytickslabel, color="grey", size=10)
plt.ylim(ylim)

# Plot each city
color1 = "#FF5733"
color2 = "#33FF57"
color3 = "#3357FF"
ax.plot(
    angles,
    values1,
    linewidth=1.5,
    linestyle="--",
    marker="o",
    markersize=5,
    label=labels[0],
    color=color1,
)
ax.fill(angles, values1, color1, alpha=0.1)

ax.plot(
    angles,
    values2,
    linewidth=1.5,
    linestyle="--",
    marker="o",
    markersize=5,
    label=labels[1],
    color=color2,
)
ax.fill(angles, values2, color2, alpha=0.1)

ax.plot(
    angles,
    values3,
    linewidth=1.5,
    linestyle="--",
    marker="o",
    markersize=5,
    label=labels[2],
    color=color3,
)
ax.fill(angles, values3, color3, alpha=0.1)

# Add data points labels
for i in range(num_vars):
    # For City A values
    ax.annotate(
        f"{values1[i]}",
        xy=(angles[i], values1[i]),
        xytext=(5, 5),
        textcoords="offset points",
        ha="right",
        va="bottom",
        size=8,
        color=color1,
    )

    # For City B values
    ax.annotate(
        f"{values2[i]}",
        xy=(angles[i], values2[i]),
        xytext=(5, 5),
        textcoords="offset points",
        ha="right",
        va="bottom",
        size=8,
        color=color2,
    )

    # For City C values
    ax.annotate(
        f"{values3[i]}",
        xy=(angles[i], values3[i]),
        xytext=(5, 5),
        textcoords="offset points",
        ha="right",
        va="bottom",
        size=8,
        color=color3,
    )

# Add a legend to the upper right
plt.legend(loc="upper right", bbox_to_anchor=(1.15, 1.15), fontsize=10)

# Add title
plt.title(title, size=15, weight="bold", pad=20)

# ===================
# Part 4: Saving Output
# ===================
# Adjust figure size to match original image's dimensions
fig.set_size_inches(8, 7)

# Adjust layout
plt.tight_layout()

plt.savefig("radar_67.pdf", bbox_inches="tight")
