
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Define the new data for each region
labels = np.array(
    [
        "Mountain\nRanges",
        "River\nSystems",
        "Forest\nCoverage",
        "Desert\nAreas",
        "Coastal\nRegions",
    ]
)
stats = np.array(
    [
        [4, 3, 5, 2, 4],  # North America
        [3, 5, 4, 3, 5],  # Europe
        [5, 4, 3, 5, 2],  # Asia
    ]
)
titles = ["North America", "Europe", "Asia"]
rticks = [1, 2, 3, 4, 5]
suptitle = "Geographical Characteristics Across Different Regions"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
fig, ax = plt.subplots(figsize=(10, 8), nrows=1, ncols=3, subplot_kw=dict(polar=True))

# Define the number of variables
num_vars = len(labels)

# Compute angle for each axis
angles = np.linspace(0, 2 * np.pi, num_vars, endpoint=False).tolist()

# The plot is made circular
stats = np.concatenate((stats, stats[:, [0]]), axis=1)
angles += angles[:1]

# Define colors
colors = ["#8B4513", "#4682B4", "#808080"]  # Earthy brown, steel blue, Industrial grey

# Draw one radar chart for each region
for idx, (title, case_data) in enumerate(zip(titles, stats)):
    ax[idx].fill(angles, case_data, color=colors[idx], alpha=0.25)
    ax[idx].plot(
        angles, case_data, color=colors[idx], linestyle="-", linewidth=2, marker="o"
    )
    ax[idx].set_rticks(rticks)
    ax[idx].set_xticks(angles[:-1])
    ax[idx].set_xticklabels(labels, fontsize=10)
    ax[idx].set_title(title, color=colors[idx], fontsize=12, fontweight="bold")
    ax[idx].grid(True)

plt.suptitle(suptitle, fontsize=14, y=1.0)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better fit
plt.tight_layout(rect=[0, 0.03, 1, 1.5])
plt.savefig("radar_70.pdf", bbox_inches="tight")
