

# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt
from math import pi

# ===================
# Part 2: Data Preparation
# ===================

import numpy as np

np.random.seed(0)

# Define the data for the radar chart
categories = [
    "Syntax Clarity",
    "Performance",
    "Community Support",
    "Library Availability",
    "Ease of Learning",
    "Popularity",
    "Job Market",
    "Documentation Quality",
]
values1 = [8, 7, 9, 8, 8, 9, 7, 8]  # Values for Language A
values2 = [7, 9, 8, 9, 6, 8, 8, 7]  # Values for Language B
values3 = [9, 6, 7, 7, 9, 8, 9, 8]  # Values for Language C

# Number of variables
N = len(categories)

# Compute angle for each category
angles = [n / float(N) * 2 * pi for n in range(N)]
values1 += values1[:1]
values2 += values2[:1]
values3 += values3[:1]
angles += angles[:1]

# Extracted variables
xticks = angles[:-1]
xtickslabel = categories
yticks = [1, 3, 5, 7, 9]
ytickslabel = ["1", "3", "5", "7", "9"]
ylim = (0, 10)
line_label1 = "Language A"
line_label2 = "Language B"
line_label3 = "Language C"
chart_title = "Programming Languages Popularity Comparison"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Initialize the spider plot
fig, ax = plt.subplots(figsize=(8, 8), subplot_kw=dict(polar=True))

# Draw one axe per variable and add labels
plt.xticks(xticks, xtickslabel, color="darkgreen", size=10)
ax.tick_params(pad=15)  # Adjust the distance of the label from the axis

# Draw ylabels
ax.set_rlabel_position(30)
plt.yticks(yticks, ytickslabel, color="black", size=8)
plt.ylim(ylim)

# Plot data
ax.plot(
    angles, values1, linewidth=2, linestyle="solid", marker='o', label=line_label1, color="forestgreen"
)
ax.fill(angles, values1, color="limegreen", alpha=0.25)

ax.plot(
    angles, values2, linewidth=2, linestyle="dotted", marker='x', label=line_label2, color="royalblue"
)
ax.fill(angles, values2, color="skyblue", alpha=0.3)

ax.plot(
    angles, values3, linewidth=2, linestyle="dashdot", marker='s', label=line_label3, color="darkorange"
)
ax.fill(angles, values3, color="orange", alpha=0.25)

# Add legend
plt.legend(loc="upper right", bbox_to_anchor=(1.2, 1.2), ncol=1, frameon=False)

# Set the background color inside the radar chart to white
ax.set_facecolor("white")

# Add Title
plt.title(chart_title, size=15, color='darkblue', pad=30)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better fit
plt.tight_layout()

plt.savefig("radar_75.pdf", bbox_inches="tight")

