
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt
from math import pi

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Define the data for the radar chart
categories = [
    "Metaphysics",
    "Epistemology",
    "Ethics",
    "Logic",
    "Aesthetics",
    "Political\nPhilosophy",
    "Philosophy\nof Science",
    "Philosophy\nof Mind",
]
values1 = [8, 7, 9, 9, 6, 7, 8, 7]  # Values for Analytic Philosophy
values2 = [7, 8, 6, 6, 9, 8, 7, 9]  # Values for Continental Philosophy
values3 = [9, 6, 8, 7, 5, 6, 9, 8]  # Values for Eastern Philosophy

# Number of variables
N = len(categories)

# Compute angle for each category
angles = [n / float(N) * 2 * pi for n in range(N)]
values1 += values1[:1]
values2 += values2[:1]
values3 += values3[:1]
angles += angles[:1]

# Extracted variables
xticks = angles[:-1]
xtickslabel = categories
yticks = [2, 4, 6, 8, 10]
ytickslabel = ["2", "4", "6", "8", "10"]
ylim = (0, 10)
line_label1 = "Analytic Philosophy"
line_label2 = "Continental Philosophy"
line_label3 = "Eastern Philosophy"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Initialize the spider plot
fig, ax = plt.subplots(figsize=(6, 6), subplot_kw=dict(polar=True))

# Draw one axe per variable and add labels
plt.xticks(xticks, xtickslabel, color="darkred", size=8)
ax.tick_params(pad=15)  # Adjust the distance of the label from the axis

# Draw ylabels
ax.set_rlabel_position(30)
plt.yticks(yticks, ytickslabel, color="darkblue", size=7)
plt.ylim(ylim)

# Plot data
ax.plot(angles, values1, linewidth=2, linestyle="-.", label=line_label1, color="blue")
ax.fill(angles, values1, color="lightblue", alpha=0.25)

ax.plot(
    angles, values2, linewidth=2, linestyle="dotted", label=line_label2, color="red"
)
ax.fill(angles, values2, color="lightcoral", alpha=0.25)

ax.plot(
    angles, values3, linewidth=2, linestyle="solid", label=line_label3, color="green"
)
ax.fill(angles, values3, color="lightgreen", alpha=0.25)

# Add legend
plt.legend(loc="upper right", bbox_to_anchor=(1.2, 1.2), ncol=1, frameon=False)

# Set the background color inside the radar chart to white
ax.set_facecolor("white")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better fit
plt.tight_layout()

plt.savefig("radar_77.pdf", bbox_inches="tight")
