
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
# Prepare data
years = np.array([2017, 2018, 2019, 2020, 2021])  # Years
city1_population = np.array([50000, 50500, 51000, 52000, 53000])  # Population in city 1
city2_population = np.array([48000, 48050, 48100, 48150, 48200])  # Population in city 2
city3_population = np.array([46000, 45500, 45000, 44500, 44000])  # Population in city 3

city1_growth = np.array([1000, 1200, 1100, 1300, 1250])  # Population growth in city 1
city2_growth = np.array([800, 850, 900, 950, 1000])  # Population growth in city 2
city3_growth = np.array([600, 650, 700, 750, 800])  # Population growth in city 3

sizes_population = np.random.randint(100, 300, size=len(years))
sizes_growth = np.random.randint(100, 300, size=len(years))

labels = ["City 1 Population", "City 2 Population", "City 3 Population"]
titles = ["Population in City 1", "Population in City 2", "Population in City 3"]
xlabel = "Year"
ylabel_population = "Population"
ylabel_growth = "Population Growth"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots with 2 rows and 3 columns
fig, axs = plt.subplots(2, 3, figsize=(18, 10))

# Define color schemes
colors_population = ["red", "orange", "yellow"]
colors_growth = ["blue", "cyan", "skyblue"]

# Plot population data
for ax, population, sizes, color, label, title in zip(
    axs[0],
    [city1_population, city2_population, city3_population],
    [sizes_population, sizes_population, sizes_population],
    colors_population,
    labels,
    titles,
):
    scatter = ax.scatter(
        years,
        population,
        s=sizes,
        c=np.linspace(0.1, 1, len(years)),
        cmap="autumn",  # Warm colors for population
        alpha=0.6,
        label=label,
        marker="o",
    )
    ax.plot(years, population, linestyle="--", color=color, linewidth=2, alpha=0.7)
    ax.set_title(title)
    ax.set_xlabel(xlabel)
    ax.set_ylabel(ylabel_population)
    ax.legend()

# Plot growth data
for ax, growth, sizes, color, label, title in zip(
    axs[1],
    [city1_growth, city2_growth, city3_growth],
    [sizes_growth, sizes_growth, sizes_growth],
    colors_growth,
    ["City 1 Growth", "City 2 Growth", "City 3 Growth"],
    ["Population Growth in City 1", "Population Growth in City 2", "Population Growth in City 3"],
):
    scatter = ax.scatter(
        years,
        growth,
        s=sizes,
        c=np.linspace(0.1, 1, len(years)),
        cmap="winter",  # Cool colors for growth
        alpha=0.6,
        label=label,
        marker="s",
    )
    ax.plot(years, growth, linestyle="-.", color=color, linewidth=2, alpha=0.7)
    ax.set_title(title)
    ax.set_xlabel(xlabel)
    ax.set_ylabel(ylabel_growth)
    ax.legend()

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better presentation
plt.tight_layout()
# Show the plot
plt.savefig("scatter_100.pdf", bbox_inches="tight")
