
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for plotting
years = [2010, 2015, 2020]

# Company A
stock_prices_a = [50, 75, 100]
market_caps_a = [500, 750, 1000]

# Company B
stock_prices_b = [30, 40, 35]
market_caps_b = [300, 400, 350]

# Company C
stock_prices_c = [80, 60, 65]
market_caps_c = [800, 600, 650]

# Labels and titles
legend_labels = ["Company A", "Company B", "Company C"]
title = "Stock Prices Trends"
xlabel = "Year"
ylabel = "Stock Price ($)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(10, 6))

# Scatter points with unique colors and markers
party_a_scatter = ax.scatter(years, stock_prices_a, s=market_caps_a, alpha=0.8, color="#1f77b4")
party_b_scatter = ax.scatter(years, stock_prices_b, s=market_caps_b, alpha=0.8, color="#ff7f0e")
party_c_scatter = ax.scatter(years, stock_prices_c, s=market_caps_c, alpha=0.8, color="#2ca02c")

# Connect points with customized lines
ax.plot(years, stock_prices_a, linestyle="--", color="#1f77b4", alpha=0.8, linewidth=2)
ax.plot(years, stock_prices_b, linestyle="-.", color="#ff7f0e", alpha=0.8, linewidth=2)
ax.plot(years, stock_prices_c, linestyle=":", color="#2ca02c", alpha=0.8, linewidth=2)

# Legend
legend = ax.legend(
    [party_a_scatter, party_b_scatter, party_c_scatter],
    legend_labels,
    title="Companies",
    loc="best",
)

for legend_handle in legend.legendHandles:
    legend_handle._sizes = [80]  # 设置图例标记的大小

legend.get_frame().set_alpha(1)  # Make legend background opaque

# Axes labels
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)

# Title of the plot
ax.set_title(title)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout
plt.tight_layout()
plt.savefig("scatter_30.pdf", bbox_inches="tight")
