
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for plotting
x_city1 = [2000, 2010, 2020]
y_city1 = [15, 16, 16.5]  # Average temperatures in Celsius
sizes_city1 = [200, 250, 300]  # Temperature influence scores

x_city2 = [2000, 2010, 2020]
y_city2 = [20, 19, 18.5]  # Average temperatures in Celsius
sizes_city2 = [300, 350, 400]  # Temperature influence scores

x_city3 = [2000, 2010, 2020]
y_city3 = [25, 26, 27]  # Average temperatures in Celsius
sizes_city3 = [400, 450, 500]  # Temperature influence scores

legend_labels = ["City1", "City2", "City3"]
title = "Temperature Trends in Different Cities Over Three Decades"
xlabel = "Year"
ylabel = "Average Temperature (°C)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Color definitions
color_city1 = "#FFB6C1"
color_city2 = "#87CEFA"
color_city3 = "#FFD700"

# Create the plot
fig, ax = plt.subplots(figsize=(6, 8))  # Adjust the size for better visualization

# Scatter points with distinct markers and colors
city1_scatter = ax.scatter(
    x_city1,
    y_city1,
    s=sizes_city1,
    alpha=0.8,
    color=color_city1,
    marker="o",
)
city2_scatter = ax.scatter(
    x_city2, y_city2, s=sizes_city2, alpha=0.8, color=color_city2, marker="s"
)
city3_scatter = ax.scatter(
    x_city3, y_city3, s=sizes_city3, alpha=0.8, color=color_city3, marker="^"
)

# Connect points with solid lines
ax.plot(
    x_city1,
    y_city1,
    linestyle="-",
    color=color_city1,
    alpha=0.8,
    linewidth=2,
)
ax.plot(x_city2, y_city2, linestyle="-", color=color_city2, alpha=0.8, linewidth=2)
ax.plot(x_city3, y_city3, linestyle="-", color=color_city3, alpha=0.8, linewidth=2)

# Legend
legend = ax.legend(
    [city1_scatter, city2_scatter, city3_scatter],
    legend_labels,
    title=title,
    loc="upper left",
    ncol=3,
)

for legend_handle in legend.legendHandles:
    legend_handle._sizes = [80]  # Set legend marker sizes

legend.get_frame().set_alpha(1)  # Make legend background opaque

# Axes labels
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)

# Grid for better readability
ax.grid(True, linestyle="--", alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout
plt.tight_layout()
plt.savefig("scatter_31.pdf", bbox_inches="tight")

