
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.lines as mlines

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Sample data for the plot; replace with actual data.
methods = ["Solar", "Wind", "Hydro", "Geothermal", "Biomass", "Nuclear"]

# Data for the subplots; each list within diversity_data and effectiveness_data corresponds to a subplot.
diversity_data = [[1.2, 1.5, 1.8, 1.4, 1.3, 1.6], [2.2, 2.4, 2.7, 2.3, 2.1, 2.5]]

effectiveness_data = [[35, 40, 60, 50, 55, 70], [60, 65, 80, 75, 70, 85]]

# Sizes for the scatter points, shared across both subplots.
scatter_sizes = [100, 150, 200, 250, 300, 350]

# Legend labels for the subplots.
ax1_legend_names = ["Initial Phase", "Intermediate Phase", "Advanced Phase", "Mature Phase"]
ax2_legend_names = ["Small Scale", "Medium Scale", "Large Scale", "Industrial Scale"]
ax1_legend_title = "Adoption Phase"
ax2_legend_title = "Implementation Scale"
xlabel = "Diversity of Applications"
ylabel = "Effectiveness (%)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create 2x1 grid of subplots with a specified figure size.
fig, axs = plt.subplots(2, 1, figsize=(8, 8))

colors = [
    "#2E91E5",
    "#E15F99",
    "#1CA71C",
    "#FB0D0D",
    "#DA16FF",
    "#222A2A",
]  # Custom colors for each method.

# Populate the subplots with scatter points and add text labels.
for idx, ax in enumerate(axs):
    for method, div, eff, size, color in zip(
        methods, diversity_data[idx], effectiveness_data[idx], scatter_sizes, colors
    ):
        ax.scatter(div, eff, s=size, color=color, alpha=0.6, edgecolor='w', linewidth=0.5)  # Plot the scatter points.
        ax.text(
            div, eff + 3, method, fontsize=10, ha='center'
        )  # Add text labels above scatter points.

    ax.set_xlabel(xlabel)  # X-axis label.
    ax.set_ylabel(ylabel)  # Y-axis label.

# Adjust the x and y limits and ticks for the subplots.
axs[0].set_xlim(1.0, 2.0)
axs[0].set_ylim(30, 75)
axs[0].set_xticks([1.0, 1.2, 1.4, 1.6, 1.8, 2.0])
axs[0].set_yticks([30, 40, 50, 60, 70])
axs[1].set_xlim(2.0, 2.8)
axs[1].set_ylim(55, 90)
axs[1].set_xticks([2.0, 2.2, 2.4, 2.6, 2.8])
axs[1].set_yticks([60, 65, 70, 75, 80, 85])

size_legend_handles = [100, 150, 250, 350]  # Sizes for the legend handles.

# Create custom legend handles for the first subplot.
ax1_legend_handles = [
    mlines.Line2D(
        [],
        [],
        color="#8080f7",
        marker="o",
        linestyle="None",
        markersize=(size**0.5) * 0.8,
        label=name,
    )  # Adjust marker size here.
    for size, name in zip(size_legend_handles, ax1_legend_names)
]

# Create custom legend handles for the second subplot.
ax2_legend_handles = [
    mlines.Line2D(
        [],
        [],
        color="#8080f7",
        marker="o",
        linestyle="None",
        markersize=(size**0.5) * 0.8,
        label=name,
    )  # Adjust marker size here.
    for size, name in zip(size_legend_handles, ax2_legend_names)
]

# Add legends to the subplots.
axs[0].legend(
    handles=ax1_legend_handles,
    loc="lower right",
    title=ax1_legend_title,
    labelspacing=2.0,
    edgecolor="black",
)
axs[1].legend(
    handles=ax2_legend_handles,
    loc="lower right",
    title=ax2_legend_title,
    labelspacing=2.0,
    edgecolor="black",
)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("scatter_32.pdf", bbox_inches="tight")
