
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.lines as mlines

# ===================
# Part 2: Data Preparation
# ===================
# Sample data for the plot; replace with actual data.
methods = [
    "Sensor Networks",
    "Manual Sampling",
    "Satellite Imaging",
    "Drones",
    "Mobile Apps",
    "Citizen Science",
]

# Data for the subplots; each list within engagement_data and improvement_data corresponds to a subplot.
engagement_data = [[10, 8, 6, 9, 7, 6], [20, 15, 25, 30, 22, 18]]
improvement_data = [[85, 70, 65, 80, 75, 68], [95, 85, 90, 88, 80, 76]]

# Sizes for the scatter points, shared across both subplots.
scatter_sizes = [100, 200, 300, 250, 150, 120]

# Legend labels for the subplots.
ax1_legend_names = ["Low Frequency", "Moderate Frequency", "High Frequency", "Very High Frequency"]
ax2_legend_names = ["< 10% Error", "10-20% Error", "20-30% Error", "> 30% Error"]
ax1_legend_title = "Data Collection Frequency"
ax2_legend_title = "Accuracy of Data"
xlabel = "Data Collection Frequency (Per Month)"
ylabel = "Data Reliability (%)"

import numpy as np

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create 2x1 grid of subplots with a specified figure size.
fig, axs = plt.subplots(2, 1, figsize=(10, 8))

colors = [
    "#1f77b4",  # blue
    "#ff7f0e",  # orange
    "#2ca02c",  # green
    "#d62728",  # red
    "#9467bd",  # purple
    "#8c564b",  # brown
]  # Colors for each method.

# Populate the subplots with scatter points and add text labels.
for idx, ax in enumerate(axs):
    for method, eng, imp, size, color in zip(
        methods, engagement_data[idx], improvement_data[idx], scatter_sizes, colors
    ):
        ax.scatter(eng, imp, s=size, color=color, alpha=0.6)  # Plot the scatter points.
        ax.text(
            eng, imp + 2, method, fontsize=9
        )  # Add text labels above scatter points.

    ax.set_xlabel(xlabel)  # X-axis label.
    ax.set_ylabel(ylabel)  # Y-axis label.

# Adjust the x and y limits and ticks for the subplots.
axs[0].set_xlim(5, 12)
axs[0].set_ylim(60, 90)
axs[0].set_xticks(np.arange(5, 13, 1))
axs[0].set_yticks(np.arange(60, 91, 10))
axs[1].set_xlim(15, 35)
axs[1].set_ylim(70, 100)
axs[1].set_xticks(np.arange(15, 36, 5))
axs[1].set_yticks(np.arange(70, 101, 10))

size_legend_handles = [50, 100, 175, 250]  # Sizes for the legend handles.

# Create custom legend handles for the first subplot.
ax1_legend_handles = [
    mlines.Line2D(
        [],
        [],
        color="#8080f7",
        marker="o",
        linestyle="None",
        markersize=(size**0.5) * 0.8,
        label=name,
    )  # Adjust marker size here.
    for size, name in zip(size_legend_handles, ax1_legend_names)
]

# Create custom legend handles for the second subplot.
ax2_legend_handles = [
    mlines.Line2D(
        [],
        [],
        color="#8080f7",
        marker="o",
        linestyle="None",
        markersize=(size**0.5) * 0.8,
        label=name,
    )  # Adjust marker size here.
    for size, name in zip(size_legend_handles, ax2_legend_names)
]

# Add legends to the subplots.
axs[0].legend(
    handles=ax1_legend_handles,
    loc="lower right",
    title=ax1_legend_title,
    labelspacing=2.0,
    edgecolor="black",
)
axs[1].legend(
    handles=ax2_legend_handles,
    loc="lower right",
    title=ax2_legend_title,
    labelspacing=2.0,
    edgecolor="black",
)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("scatter_34.pdf", bbox_inches="tight")
