
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generate new data for tourism clusters
clusters = {
    "Beaches": np.random.multivariate_normal([10, 15], [[2, 0.5], [0.5, 2]], 20),
    "Mountains": np.random.multivariate_normal([-5, 20], [[1.5, 0], [0, 1.5]], 20),
    "Cities": np.random.multivariate_normal([20, 5], [[3, 1], [1, 3]], 20),
    "Historical Sites": np.random.multivariate_normal([0, 0], [[2, -0.5], [-0.5, 2]], 20),
    "Amusement Parks": np.random.multivariate_normal([15, -5], [[2, 1], [1, 2]], 20),
    "Wildlife Reserves": np.random.multivariate_normal([-10, -15], [[2.5, 0.8], [0.8, 2.5]], 20),
}

# Variables for plot configuration
xlim = [-15, 25]
ylim = [-20, 25]
xlabel = "Latitude"
ylabel = "Longitude"
title = "Tourist Attraction Clusters"
legendlabels = {
    "Beaches": "Beaches",
    "Mountains": "Mountains",
    "Cities": "Cities",
    "Historical Sites": "Historical Sites",
    "Amusement Parks": "Amusement Parks",
    "Wildlife Reserves": "Wildlife Reserves",
}

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(8, 8))

# New color scheme for clusters
colors = {
    "Beaches": "#FF6347",  # Tomato
    "Mountains": "#4682B4",  # SteelBlue
    "Cities": "#9370DB",  # MediumPurple
    "Historical Sites": "#3CB371",  # MediumSeaGreen
    "Amusement Parks": "#FFD700",  # Gold
    "Wildlife Reserves": "#FF4500",  # OrangeRed
}

# Plot each cluster
for cluster, data in clusters.items():
    plt.scatter(
        data[:, 0],
        data[:, 1],
        c=colors[cluster],
        alpha=0.7,
        edgecolors="w",
        s=100,
        label=legendlabels[cluster],
    )

# Set limits
plt.xlim(xlim)
plt.ylim(ylim)

# Set labels and title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# Remove grid
plt.grid(False)

# Enable legend
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("scatter_35.pdf", bbox_inches="tight")
