

# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# New clusters representing political opinion groups
clusters = {
    "group_1": np.random.multivariate_normal([25, 40], [[30, 5], [5, 20]], 20),
    "group_2": np.random.multivariate_normal([60, 60], [[15, 3], [3, 25]], 20),
    "group_3": np.random.multivariate_normal([80, 20], [[20, 4], [4, 10]], 20),
    "group_4": np.random.multivariate_normal([40, 70], [[25, 5], [5, 15]], 20),
    "group_5": np.random.multivariate_normal([70, 50], [[15, 2], [2, 10]], 20),
    "group_6": np.random.multivariate_normal([90, 30], [[20, 6], [6, 15]], 20),
}

# Variables for plot configuration
xlim = [0, 100]
ylim = [0, 100]
xlabel = "Economic Policy Support"
ylabel = "Social Policy Support"
xticks = np.arange(0, 101, 20)
yticks = np.arange(0, 101, 20)
xtickslabel = xticks.astype(str)
ytickslabel = yticks.astype(str)
title = "Public Opinion Clusters on Political Issues"
legendlabels = ["Group 1: Younger, Economically Liberal", "Group 2: Older, Socially Conservative",
                "Group 3: Middle-aged, Economically Conservative", "Group 4: Younger, Socially Liberal",
                "Group 5: Older, Centrists", "Group 6: Middle-aged, Mixed Views"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the scatter plot
plt.figure(figsize=(10, 7))

# Colors for each cluster
colors = {
    "group_1": "#D55E00",
    "group_2": "#009E73",
    "group_3": "#0072B2",
    "group_4": "#F0E442",
    "group_5": "#CC79A7",
    "group_6": "#56B4E9",
}

markers = {
    "group_1": "o",
    "group_2": "s",
    "group_3": "d",
    "group_4": "^",
    "group_5": "v",
    "group_6": "<",
}

for cluster, data in clusters.items():
    plt.scatter(data[:, 0], data[:, 1], c=colors[cluster], alpha=0.6, edgecolors='w', s=100, label=legendlabels.pop(0), marker=markers[cluster])

# Applying configurations
plt.xlim(xlim)
plt.ylim(ylim)
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.xticks(xticks, xtickslabel)
plt.yticks(yticks, ytickslabel)
plt.title(title)
plt.legend(loc="best")
plt.grid(True, linestyle='--', alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("scatter_37.pdf", bbox_inches="tight")

