

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data points for each psychological group with (Stress Level, Sleep Quality)
student = [(70, 60), (75, 55)]
working_professional = [(65, 70), (80, 50)]
retired = [(30, 80), (40, 85)]
unemployed = [(60, 65), (85, 45)]
freelancer = [(50, 75), (55, 70)]
other = [(40, 60), (45, 65)]
labels = ["Student", "Working Professional", "Retired", "Unemployed", "Freelancer", "Other"]
xlabel = "Stress Level"
ylabel = "Sleep Quality"
title = "Scatter Plot of Sleep Quality vs Stress Level"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a scatter plot
fig, ax = plt.subplots(figsize=(10, 6))

# Plot each group with different color and marker
ax.scatter(*zip(*student), color="#2E8B57", label=labels[0], s=100, marker="o")  # SeaGreen
ax.scatter(*zip(*working_professional), color="#4682B4", label=labels[1], s=100, marker="^")  # SteelBlue
ax.scatter(*zip(*retired), color="#6A5ACD", label=labels[2], s=100, marker="s")  # SlateBlue
ax.scatter(*zip(*unemployed), color="#FF8C00", label=labels[3], s=100, marker="D")  # DarkOrange
ax.scatter(*zip(*freelancer), color="#8A2BE2", label=labels[4], s=100, marker="P")  # BlueViolet
ax.scatter(*zip(*other), color="#20B2AA", label=labels[5], s=100, marker="*")  # LightSeaGreen

# Add legend
ax.legend(loc="upper right")

# Add labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
fig.tight_layout()
plt.savefig("scatter_38.pdf", bbox_inches="tight")

