
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data points for each job sector (Years of Experience, Average Annual Salary)
technology = [(1, 55000), (5, 75000), (10, 100000)]
finance = [(2, 60000), (6, 85000), (12, 120000)]
healthcare = [(3, 45000), (7, 70000), (15, 95000)]
education = [(2, 40000), (8, 60000), (20, 80000)]
labels = ["Technology", "Finance", "Healthcare", "Education"]
xlabel = "Years of Experience"
ylabel = "Average Annual Salary ($)"
title = "Scatter Plot of Salary vs Experience Level"
annotation_text = "Key Technology Data Point"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Custom color scheme
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728"]

# Create a scatter plot
fig, ax = plt.subplots(figsize=(8, 8))

# Plot each group with different color and marker
ax.scatter(
    *zip(*technology), color=colors[0], label=labels[0], marker="o", s=100, alpha=0.7
)
ax.scatter(
    *zip(*finance), color=colors[1], label=labels[1], marker="s", s=100, alpha=0.7
)
ax.scatter(
    *zip(*healthcare), color=colors[2], label=labels[2], marker="^", s=100, alpha=0.7
)
ax.scatter(
    *zip(*education), color=colors[3], label=labels[3], marker="D", s=100, alpha=0.7
)

# Add legend
ax.legend(loc="upper left")

# Add labels and title
ax.set_xlabel(xlabel, fontsize=14)
ax.set_ylabel(ylabel, fontsize=14)
ax.set_title(title, fontsize=16)

# Add grid for better readability
ax.grid(True, which="both", linestyle="--", linewidth=0.5)

# Highlight a particular data point with annotation (example)
highlight_point = (1, 55000)
ax.annotate(
    annotation_text,
    xy=highlight_point,
    xytext=(3, 65000),
    arrowprops=dict(facecolor="black", arrowstyle="->"),
)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
fig.tight_layout()
plt.savefig("scatter_39.pdf", bbox_inches="tight")
