

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data points for each group representing vehicle types
sedans = [(120, 15), (150, 14)]
suvs = [(110, 12), (140, 10)]
hatchbacks = [(130, 18), (160, 17)]
trucks = [(90, 8), (110, 7)]
motorcycles = [(100, 20), (130, 18)]
evs = [(120, 25), (150, 22)]
labels = ["Sedans", "SUVs", "Hatchbacks", "Trucks", "Motorcycles", "EVs"]
xlabel = "Speed (km/h)"
ylabel = "Fuel Efficiency (km/L)"
title = "Vehicle Performance: Speed vs Fuel Efficiency"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a scatter plot
fig, ax = plt.subplots(figsize=(8, 6))

# Define color and marker scheme
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd", "#8c564b"]
markers = ["o", "s", "D", "^", "v", "<"]

# Plot each group with different color and marker
ax.scatter(*zip(*sedans), color=colors[0], label=labels[0], marker=markers[0])
ax.scatter(*zip(*suvs), color=colors[1], label=labels[1], marker=markers[1])
ax.scatter(*zip(*hatchbacks), color=colors[2], label=labels[2], marker=markers[2])
ax.scatter(*zip(*trucks), color=colors[3], label=labels[3], marker=markers[3])
ax.scatter(*zip(*motorcycles), color=colors[4], label=labels[4], marker=markers[4])
ax.scatter(*zip(*evs), color=colors[5], label=labels[5], marker=markers[5])

# Add legend
ax.legend(loc="upper right")

# Add labels and title
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_title(title, fontsize=14)
ax.grid(True)  # Adding grid

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
fig.tight_layout()
plt.savefig("scatter_40.pdf", bbox_inches="tight")

