
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Usage data for three periods in technology adoption
np.random.seed(0)
# Generate sample data for three periods with adjusted positions and spread
x_adoption = np.random.normal(1, 0.5, 100)
y_adoption = np.random.normal(100, 20, 100)

x_peak = np.random.normal(5, 0.5, 100)
y_peak = np.random.normal(300, 50, 100)

x_decline = np.random.normal(9, 0.5, 100)
y_decline = np.random.normal(150, 30, 100)

# Labels and other text parameters
xlabel = "Time Period (Years)"
ylabel = "Average Device Usage (Hours/Day)"
title = "Technology Adoption: Device Usage Over Time"
suptitle = "Device Usage Trends"
labels = ["Early Adoption", "Peak Use", "Decline"]
legend_location = "upper right"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
plt.figure(figsize=(10, 7))

# Plot the data with optimized colors and markers
plt.scatter(x_adoption, y_adoption, c="#1f77b4", marker='o', label=labels[0], alpha=0.7)
plt.scatter(x_peak, y_peak, c="#2ca02c", marker='s', label=labels[1], alpha=0.7)
plt.scatter(x_decline, y_decline, c="#d62728", marker='^', label=labels[2], alpha=0.7)

# Add titles and labels
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)
plt.suptitle(suptitle)

# Add the legend with adjusted order of labels
plt.legend(loc=legend_location, frameon=True)

# Add grid for better readability
plt.grid(True)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with a tight layout to minimize white space
plt.tight_layout(rect=[0, 0.03, 1, 0.95])  # Adjust the rect parameter to fit the suptitle
plt.savefig("scatter_41.pdf", bbox_inches="tight")
