

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Setting seed for reproducibility
np.random.seed(42)

# Generate sample data for three entertainment sub-sectors
x_movies = np.random.normal(5, 1.5, 100)
y_movies = np.random.normal(70, 10, 100)

x_music = np.random.normal(15, 3, 100)
y_music = np.random.normal(60, 15, 100)

x_gaming = np.random.normal(25, 5, 100)
y_gaming = np.random.normal(80, 20, 100)

# Labels for sub-sectors
labels = ["Movies", "Music", "Gaming"]

# Chart text labels
xlabel = 'Time (months)'
ylabel = 'Popularity Index'
title = 'Entertainment Sub-Sectors Popularity Distribution'
legend_labels = ["Movies Sub-Sector", "Music Sub-Sector", "Gaming Sub-Sector"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to be comprehensive
plt.figure(figsize=(10, 6))

# Plot the data with different colors and markers
plt.scatter(x_movies, y_movies, c="#ff7f0e", label=labels[0], marker='o')
plt.scatter(x_music, y_music, c="#1f77b4", label=labels[1], marker='s')
plt.scatter(x_gaming, y_gaming, c="#2ca02c", label=labels[2], marker='^')

# Add the legend with clear labels
plt.legend(legend_labels, loc="upper left", frameon=True)

# Add axis labels and a title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# Add gridlines for readability
plt.grid(True)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout
plt.tight_layout()
plt.savefig("scatter_43.pdf", bbox_inches="tight")

