
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data points for educational fields, number of research papers and citation score.
fields = [
    "Physics",
    "Chemistry",
    "Biology",
    "Mathematics",
    "Computer Science",
    "Economics",
]
papers = [200, 150, 100, 80, 120, 60]  # Number of research papers published
citations = [85, 70, 65, 55, 90, 45]  # Citation score (%)

# Labels and title
xlabel = "Number of Research Papers"
ylabel = "Citation Score (%)"
title = "Research Field Citations vs. Number of Papers"
supertitle = "Educational Field Analysis"
legend_labels = fields
legendtitle="Fields"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and a subplot with a specific size.
fig, ax = plt.subplots(figsize=(8, 5))

# Color scheme reflecting educational fields
colors = ["#FFB6C1", "#87CEEB", "#FFD700", "#40E0D0", "#FFA07A", "#9370DB"]
markers = ["o", "v", "^", "<", ">", "*"]

# Scatter plot each field's data point and add text annotation.
for i in range(len(fields)):
    ax.scatter(
        papers[i],
        citations[i],
        color=colors[i],
        marker=markers[i],
        s=100,
        edgecolor="k",
    )
    ax.text(
        papers[i] + 5,
        citations[i] + 1,
        fields[i],
        fontsize=10,
        ha="left",
        va="bottom",
    )

# Add a horizontal and a vertical dashed reference line.
ax.axhline(
    y=60, color="gray", linestyle="--", linewidth=1
)  # Horizontal line at Citations=60%
ax.axvline(
    x=100, color="gray", linestyle="--", linewidth=1
)  # Vertical line at Papers=100

# Set the scales of the axes to logarithmic.
ax.set_xscale("log")
ax.set_yscale("log")

# Set the labels for the axes.
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)

# Set the title of the plot.
ax.set_title(title)
fig.suptitle(supertitle, fontsize=14)

# Adding grid
ax.grid(True, which="both", linestyle="--", linewidth=0.5)

# Adding legend
for i, label in enumerate(legend_labels):
    ax.scatter([], [], color=colors[i], marker=markers[i], label=label)
ax.legend(title=legendtitle)

# Define major ticks for both axes.
ax.set_xticks([50, 100, 200, 300, 500])
ax.get_xaxis().set_major_formatter(plt.ScalarFormatter())
ax.set_yticks([40, 55, 65, 70, 85, 95])
ax.get_yaxis().set_major_formatter(plt.ScalarFormatter())

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with a tight layout to ensure all elements fit within the figure area.
plt.tight_layout(rect=[0, 0, 1, 0.95])  # Adjust for supertitle
plt.savefig("scatter_45.pdf", bbox_inches="tight")
