
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Simulate some data for the scatter plot
n_points = 200
age_20_30_x = np.random.normal(3, 0.5, n_points)
age_20_30_y = np.random.normal(30000, 5000, n_points)
age_30_40_x = np.random.normal(4, 0.5, n_points)
age_30_40_y = np.random.normal(50000, 8000, n_points)
age_40_50_x = np.random.normal(5, 0.5, n_points)
age_40_50_y = np.random.normal(70000, 10000, n_points)
age_50_60_x = np.random.normal(6, 0.5, n_points)
age_50_60_y = np.random.normal(85000, 12000, n_points)

xlabel = "Education Level (Years of Schooling)"
ylabel = "Income Level ($/year)"
title = "Income Distribution by Education and Age"
legend_title = "Age Groups"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the scatter plot
color_20_30 = "#1f77b4"
color_30_40 = "#ff7f0e"
color_40_50 = "#2ca02c"
color_50_60 = "#d62728"

plt.figure(figsize=(10, 10))
plt.scatter(age_20_30_x, age_20_30_y, color=color_20_30, alpha=0.6, marker='o', label="20-30 years")
plt.scatter(age_30_40_x, age_30_40_y, color=color_30_40, alpha=0.6, marker='s', label="30-40 years")
plt.scatter(age_40_50_x, age_40_50_y, color=color_40_50, alpha=0.6, marker='^', label="40-50 years")
plt.scatter(age_50_60_x, age_50_60_y, color=color_50_60, alpha=0.6, marker='d', label="50-60 years")

# Add grid lines for better readability
plt.grid(True, linestyle='--', alpha=0.7)

# Add labels and title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)
plt.legend(title=legend_title, ncol=2, bbox_to_anchor=(0.5, -0.1), loc="upper center", frameon=False)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout
plt.tight_layout()
plt.savefig("scatter_47.pdf", bbox_inches="tight")
