
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt
from matplotlib.lines import Line2D

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for Happiness Index plot (HPI)
hpi_x = [70, 80, 90, 60, 85]
hpi_y = [10, 5, 7, 15, 6]
hpi_labels = ["Urban", "Rural", "Coastal", "Mountain", "Suburban"]

# Data for Stress Level Index plot (SLI)
sli_x = [40, 50, 45, 30, 35]
sli_y = [5, 7, 6, 4, 3]
sli_labels = ["Morning", "Afternoon", "Evening", "Night", "Late Night"]

# Extracted variables for plot configuration
hpi_title = "Happiness Index"
hpi_xlabel = "Happiness Score"
hpi_ylabel = "Number of Complaints"
hpi_xlim = (50, 100)
hpi_xticks = [50, 60, 70, 80, 90, 100]
hpi_ylim = (0, 20)
hpi_yticks = [0, 5, 10, 15, 20]

sli_title = "Stress Level Index"
sli_xlabel = "Stress Level"
sli_ylabel = "Incidents Reported"
sli_xlim = (20, 60)
sli_xticks = [20, 30, 40, 50, 60]
sli_ylim = (2, 10)
sli_yticks = [2, 4, 6, 8, 10]

# Colors for categories
hpi_colors = ["#76b7b2", "#4e79a7", "#f28e2c", "#e15759", "#59a14f"]
sli_colors = ["#76b7b2", "#4e79a7", "#f28e2c", "#e15759", "#59a14f"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(7, 10))

# HPI plot
for x, y, color, label in zip(hpi_x, hpi_y, hpi_colors, hpi_labels):
    ax1.scatter(x, y, label=label, color=color, s=200)  # Increase marker size
ax1.set_title(hpi_title)
ax1.set_xlabel(hpi_xlabel)
ax1.set_ylabel(hpi_ylabel)
ax1.set_xlim(hpi_xlim)  # Adjust x-axis range
ax1.set_xticks(hpi_xticks)
ax1.set_ylim(hpi_ylim)  # Adjust y-axis range
ax1.set_yticks(hpi_yticks)
ax1.grid(True, linestyle="--", linewidth=0.5, color="black")  # Add grid

# SLI plot
for x, y, color, label in zip(sli_x, sli_y, sli_colors, sli_labels):
    ax2.scatter(x, y, label=label, color=color, s=200)  # Increase marker size
ax2.set_title(sli_title)
ax2.set_xlabel(sli_xlabel)
ax2.set_ylabel(sli_ylabel)
ax2.set_xlim(sli_xlim)  # Adjust x-axis range
ax2.set_xticks(sli_xticks)
ax2.set_ylim(sli_ylim)  # Adjust y-axis range
ax2.set_yticks(sli_yticks)
ax2.grid(True, linestyle="--", linewidth=0.5, color="black")  # Add grid

legend_elements = [
    Line2D(
        [0],
        [0],
        marker="o",
        color="w",
        label="Urban",
        markersize=10,
        markerfacecolor="#76b7b2",
    ),
    Line2D(
        [0],
        [0],
        marker="o",
        color="w",
        label="Rural",
        markersize=10,
        markerfacecolor="#4e79a7",
    ),
    Line2D(
        [0],
        [0],
        marker="o",
        color="w",
        label="Coastal",
        markersize=10,
        markerfacecolor="#f28e2c",
    ),
    Line2D(
        [0],
        [0],
        marker="o",
        color="w",
        label="Mountain",
        markersize=10,
        markerfacecolor="#e15759",
    ),
    Line2D(
        [0],
        [0],
        marker="o",
        color="w",
        label="Suburban",
        markersize=10,
        markerfacecolor="#59a14f",
    ),
    Line2D(
        [0],
        [0],
        marker="o",
        color="w",
        label="Morning",
        markersize=10,
        markerfacecolor="#76b7b2",
    ),
    Line2D(
        [0],
        [0],
        marker="o",
        color="w",
        label="Afternoon",
        markersize=10,
        markerfacecolor="#4e79a7",
    ),
    Line2D(
        [0],
        [0],
        marker="o",
        color="w",
        label="Evening",
        markersize=10,
        markerfacecolor="#f28e2c",
    ),
    Line2D(
        [0],
        [0],
        marker="o",
        color="w",
        label="Night",
        markersize=10,
        markerfacecolor="#e15759",
    ),
    Line2D(
        [0],
        [0],
        marker="o",
        color="w",
        label="Late Night",
        markersize=10,
        markerfacecolor="#59a14f",
    ),
]

# Create the legend using the custom handles
fig.legend(
    handles=legend_elements,
    loc="lower center",
    ncol=5,
    borderaxespad=0.05,
    frameon=False,
    bbox_to_anchor=(0.5, -0.05),
)

# Adjust the layout to make room for the legend
plt.subplots_adjust(bottom=0.1)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig("scatter_50.pdf", bbox_inches="tight")

