
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data points (Year-wise Publications and Citations)
years = [2000, 2002, 2005, 2008, 2012, 2015, 2017, 2019, 2021]
publications = [5, 8, 12, 15, 20, 25, 30, 35, 40]
citations = [20, 35, 50, 70, 100, 150, 180, 220, 300]
labels = [None, "Year 2002", None, "Year 2008", None, "Year 2015", "Year 2017", None, "Year 2021"]
dashed_lines = [(2000, 5, 2002, 8), (2008, 15, 2015, 25), (2017, 30, 2021, 40)]

title = "Seminal Publications in Philosophy Over the Years"
xlabel = "Year"
ylabel = "Number of Publications"
texts = ["+3 from 2000", "Expansion Period", "+10", "+10 from 2017"]

legend_labels = ["Publications", "Citations"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data points
plt.figure(figsize=(10, 6))
color_marker = "#2A9D8F"
color_line_1 = "#E76F51"
color_line_2 = "#264653"
color_line_3 = "#F4A261"

plt.scatter(
    years, publications, color=color_marker, s=120, marker="o"
)  # Customized marker color and size

# Annotating the data points
for i, label in enumerate(labels):
    plt.annotate(
        label,
        (years[i], publications[i]),
        textcoords="offset points",
        xytext=(0, 10),
        ha="center",
    )

# Plotting the dashed lines with correct colors and annotations
plt.plot([2000, 2002], [5, 8], linestyle="--", color=color_line_1)
plt.annotate(texts[0], (2001, 6.5), color=color_line_1)
plt.plot([2008, 2015], [15, 25], linestyle="--", color=color_line_2)
plt.annotate(texts[1], (2011.5, 20), color=color_line_2)
plt.plot([2017, 2021], [30, 40], linestyle="--", color=color_line_3)
plt.annotate(
    texts[2],
    (2019, 32.5),
    color=color_line_3,
    textcoords="offset points",
    xytext=(0, 10),
    ha="center",
)

# Annotating the dashed lines correctly
plt.annotate(texts[3], (2019, 35), color=color_line_3)

# Setting the title and labels
plt.title(title)
plt.xlabel(xlabel)
plt.ylabel(ylabel)

# Adjusting y-axis scale
plt.ylim(0, 50)
plt.yticks(np.arange(0, 51, 5))
plt.xlim(1999, 2022)
plt.xticks(np.arange(2000, 2022, 2))
plt.grid(True, linestyle="--", alpha=0.7)

# removing the top, left, and right spines
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["right"].set_visible(False)
plt.gca().spines["left"].set_visible(False)

# Adding legend
plt.legend(legend_labels, loc="upper left")

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout
plt.tight_layout()
plt.savefig("scatter_54.pdf", bbox_inches="tight")
