
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt
import matplotlib.ticker as ticker

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for plotting
cities = ["City X", "City Y", "City Z", "City W", "City V", "City U"]
life_expectancy = [78, 82, 74, 80, 76, 81]  # Life Expectancy (years)
healthcare_spending = [4.5, 6.0, 3.8, 5.2, 4.0, 5.8]  # Healthcare Spending ($ '000)
population = [450, 620, 380, 540, 450, 500]  # Population (in '000)

# Plot and legend labels
scatter_label = "Bubble Size: Population ('000)"

# Axis limits
xlim_values = (3.5, 6.5)
ylim_values = (72, 85)

# Axis labels
xlabel_value = "Average Healthcare Spending ($ '000)"
ylabel_value = "Life Expectancy (years)"

# Axis ticks
xticks_values = np.arange(3.5, 7.0, 0.5)
yticks_values = np.arange(72, 86, 2)

# Title
title_value = "Life Expectancy vs. Healthcare Spending in Different Cities"

# Horizontal and vertical lines
axhline_values = None  # Not explicitly set in the code
axvline_values = None  # Not explicitly set in the code

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a scatter plot
fig, ax = plt.subplots(figsize=(10, 8))
colors = ["#FF6347", "#4682B4", "#32CD32", "#FFD700", "#FF69B4", "#8A2BE2"]
scatter = ax.scatter(
    healthcare_spending,
    life_expectancy,
    s=np.array(population) * 10,
    c=colors,
    alpha=0.6,
    edgecolors="black",
    label=scatter_label,
)

# Add labels for each bubble
for i, txt in enumerate(cities):
    ax.annotate(
        txt,
        (healthcare_spending[i], life_expectancy[i]),
        ha="center",
        va="center",
        fontsize=10,
        color="black",
    )

# Set axis labels
ax.set_xlabel(xlabel_value, fontsize=12)
ax.set_ylabel(ylabel_value, fontsize=12)
ax.set_xlim(xlim_values)
ax.set_ylim(ylim_values)

# Set axis ticks
ax.set_xticks(xticks_values)
ax.set_yticks(yticks_values)

# Add grid
ax.grid(True, which="both", linestyle="--", linewidth=0.7)

# Set background color to white
fig.patch.set_facecolor("white")
ax.set_facecolor("white")

# Add title
ax.set_title(title_value, fontsize=14, weight="bold")

# Add legend
legend = ax.legend()

for legend_handle in legend.legendHandles:
    legend_handle._sizes = [80]

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("scatter_58.pdf", bbox_inches="tight")
