
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for plotting
names = [
    "Lionel Messi",
    "Cristiano Ronaldo",
    "Neymar Jr",
    "Kylian Mbappe",
    "Luka Modric",
    "Kevin De Bruyne",
    "Sergio Ramos",
    "Virgil van Dijk",
    "Robert Lewandowski",
]
x = [30, 28, 22, 25, 10, 15, 5, 8, 25]
y = [25, 18, 20, 10, 25, 30, 5, 15, 10]
sizes = [600, 580, 500, 450, 400, 420, 360, 380, 410]
xlabel = "Goals Scored"
ylabel = "Assists"
legend_sizes = [360, 400, 500, 600]
legend_labels = ["360", "400", "500", "600"]
legend_title = "Impact Score"
title = "Performance of Top Football Players"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and plot
fig, ax = plt.subplots(figsize=(8, 6))
colors = [
    "#2E8B57",
    "#DAA520",
    "#4682B4",
    "#FF6347",
    "#8A2BE2",
    "#D2691E",
    "#FF4500",
    "#008080",
    "#1E90FF",
]
scatter = ax.scatter(x, y, s=sizes, c=colors, alpha=0.6, edgecolor="w", linewidth=0.5)

# Add annotations
for i, name in enumerate(names):
    ax.annotate(
        name,
        (x[i], y[i]),
        textcoords="offset points",
        xytext=(0, 5),
        ha="center",
        fontsize=8,
        color=colors[i],
    )

# Customize the axes
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_xlim(0, 35)
ax.set_ylim(0, 35)

# Add legend for bubble sizes
for size, label in zip(legend_sizes, legend_labels):
    ax.scatter(
        [], [], c="grey", alpha=0.6, s=size, label=label, edgecolor="w", linewidth=0.5
    )

# Adjust the legend to have increased spacing
ax.legend(
    scatterpoints=1,
    frameon=False,
    labelspacing=2,
    handletextpad=2,
    columnspacing=6,
    title=legend_title,
    fontsize=9,
    loc="upper right",
    bbox_to_anchor=(1.3, 1),
    ncol=1,
)

plt.grid(True, linestyle="--", linewidth=0.5)
plt.title(title, fontsize=14, pad=20)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("scatter_59.pdf", bbox_inches="tight")
