
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for plotting
year_index = [2010, 2012, 2014, 2016, 2018]
car_speed = [60, 62, 63, 65, 66]  # Average speed in mph
bus_speed = [45, 46, 47, 48, 49]
bike_speed = [12, 13, 13, 14, 14]

# Labels and Titles
xlabel = "Year"
ylabel = "Average Speed (mph)"
title = "Average Speed of Different Transport Modes Over a Decade"

# Legend labels
car_label = "Car"
bus_label = "Bus"
bike_label = "Bike"

# Plot limits
xlim_values = (2009, 2019)
ylim_values = (10, 70)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set figure size in inches
plt.figure(figsize=(10, 7))

# Colors for the scatter plots
car_color = "#1f77b4"  # blue
bus_color = "#ff7f0e"  # orange
bike_color = "#2ca02c"  # green

# Plotting the data with adjusted marker sizes
plt.scatter(
    year_index,
    car_speed,
    label=car_label,
    color=car_color,
    clip_on=False,
    zorder=10,
    marker="^",
    s=200,
)  # Adjusted marker size
plt.scatter(
    year_index,
    bus_speed,
    label=bus_label,
    clip_on=False,
    zorder=10,
    color=bus_color,
    marker="s",
    s=200,
)  # Adjusted marker size
plt.scatter(
    year_index,
    bike_speed,
    label=bike_label,
    clip_on=False,
    zorder=10,
    color=bike_color,
    marker="o",
    s=150,
)  # Adjusted marker size

# Adding labels and title
plt.xlabel(xlabel, fontsize=14)
plt.ylabel(ylabel, fontsize=14)
plt.title(title, fontsize=16, y=1.1)

# Adding a legend with adjusted order and customization
handles, labels = plt.gca().get_legend_handles_labels()
order = [2, 1, 0]  # Adjusted order to match the reference picture
legend = plt.legend(
    [handles[idx] for idx in order],
    [labels[idx] for idx in order],
    loc="upper left",
    ncol=1,
    frameon=True,
)
for legend_handle in legend.legendHandles:
    legend_handle._sizes = [80]

plt.xlim(*xlim_values)
plt.ylim(*ylim_values)
# Show grid with custom settings
plt.grid(True, linestyle="--", linewidth=0.7, alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("scatter_62.pdf", bbox_inches="tight")
