
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================

# Data for plotting
years = [2018, 2019, 2020, 2021, 2022]
region_X_energy = [450, 470, 480, 490, 500]  # in Terawatt-hours (TWh)
region_Y_energy = [300, 320, 330, 340, 350]  # in Terawatt-hours (TWh)
region_Z_energy = [200, 210, 215, 220, 225]  # in Terawatt-hours (TWh)

# Labels and Titles
xlabel = "Year"
ylabel = "Energy Consumption (TWh)"
title = "Annual Energy Consumption Over Years"

# Legend labels
region_X_label = "Region X"
region_Y_label = "Region Y"
region_Z_label = "Region Z"

# Plot limits
xlim_values = (2017.5, 2022.5)
ylim_values = (190, 510)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================

# Set figure size in inches to match the original image's dimensions
plt.figure(figsize=(10, 8))

# Plotting the data with adjusted marker sizes
plt.scatter(
    years,
    region_X_energy,
    label=region_X_label,
    color="#1f77b4",  # Light blue
    marker="o",
    s=100,
    zorder=10
)
plt.scatter(
    years,
    region_Y_energy,
    label=region_Y_label,
    color="#ff7f0e",  # Orange
    marker="s",
    s=100,
    zorder=10
)
plt.scatter(
    years,
    region_Z_energy,
    label=region_Z_label,
    color="#2ca02c",  # Green
    marker="^",
    s=100,
    zorder=10
)

# Adding labels and title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title, y=1.05)

# Adding a legend with adjusted order
handles, labels = plt.gca().get_legend_handles_labels()
order = [0, 1, 2]  # Order to match the reference picture
plt.legend(
    [handles[idx] for idx in order],
    [labels[idx] for idx in order],
    loc="upper left",
    frameon=False,
    ncol=3
)

plt.xlim(*xlim_values)
plt.ylim(*ylim_values)

# Show grid
plt.grid(True)

# ===================
# Part 4: Saving Output
# ===================

# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("scatter_64.pdf", bbox_inches="tight")
