
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for plotting
categories = [
    "Beaches",
    "Mountains",
    "Historical Sites",
    "Museums",
    "National Parks",
    "Theme Parks",
    "Urban Landmarks",
    "Wildlife Reserves"
]
domestic_preference = [0.70, 0.85, 0.65, 0.75, 0.80, 0.60, 0.55, 0.50]
international_preference = [0.50, 0.60, 0.75, 0.80, 0.85, 0.70, 0.65, 0.60]
xlabel = "Tourist Attractions"
ylabel = "Preference Rating"
labels = ["Domestic Tourists", "International Tourists"]
title = "Tourist Attraction Preferences among Domestic and International Tourists"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set figure size
plt.figure(figsize=(8, 4))

# Plotting the data
plt.scatter(categories, domestic_preference, color="#FF5733", label=labels[0], marker='o')
plt.scatter(categories, international_preference, color="#33C1FF", label=labels[1], marker='s')

# Adding labels and title
plt.xlabel(xlabel, fontsize=12)
plt.ylabel(ylabel, fontsize=12)
plt.title(title, fontsize=14)

# Adding grid
plt.grid(True, linestyle="--", linewidth=0.5)

# Rotate x-axis labels for better readability
plt.xticks(rotation=45, fontsize=10)
plt.ylim(0, 1)

# Adjusting legend placement
plt.legend(loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("scatter_65.pdf", bbox_inches="tight")
