
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for plotting
categories = [
    "Solar",
    "Wind",
    "Hydro",
    "Nuclear",
    "Geothermal",
    "Biomass",
    "Coal",
    "Oil",
]
majority_accuracy = [0.90, 0.85, 0.80, 0.75, 0.70, 0.65, 0.60, 0.55]
minority_accuracy = [0.25, 0.30, 0.35, 0.40, 0.45, 0.50, 0.55, 0.60]
xlabel = "Energy Sources"
ylabel = "Representation Accuracy"
labels = ["Majority Group", "Minority Group"]
title = "Representation Accuracy for Various Energy Sources"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set figure size to match the original image's dimensions
plt.figure(figsize=(7, 4))

# Plotting the data with custom colors and markers
color_majority = "#377eb8"
color_minority = "#ff7f00"
plt.scatter(categories, majority_accuracy, color=color_majority, marker="o", label=labels[0])
plt.scatter(categories, minority_accuracy, color=color_minority, marker="s", label=labels[1])

# Adding labels and title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# Adding grid
plt.grid(True, linestyle="--", linewidth=0.5)

# Rotate x-axis labels for better readability
plt.xticks(rotation=45)
plt.ylim(0, 1)

# Adjusting legend placement to match the reference picture
plt.legend(loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout to match the reference picture
plt.tight_layout()
plt.savefig("scatter_67.pdf", bbox_inches="tight")
