
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for the plots
psychologists = [
    "Freud",
    "Jung",
    "Skinner",
    "Piaget",
    "Rogers",
    "Bandura",
    "Adler",
]
years_active_since_2023 = [120, 110, 100, 90, 80, 70, 60]
citation_scores = [85, 80, 90, 75, 70, 65, 60]

contributions = [65, 75, 80, 70, 60, 85, 90]
influence_scores = [85, 80, 90, 75, 70, 65, 60]

titles = [
    "Psychologist Influence over Time",
    "Psychologist Contributions versus Influence",
]
xlabels = ["Years Active since 2023", "Number of Studies"]
ylabels = ["Citation Score", "Influence Score"]

# Marker sizes based on citation scores
sizes1 = np.array(citation_scores) * 5
sizes2 = np.array(influence_scores) * 5

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 5))

# Colors
colors1 = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd", "#8c564b", "#e377c2"]
colors2 = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd", "#8c564b", "#e377c2"]

# First subplot
scatter1 = ax1.scatter(
    years_active_since_2023,
    citation_scores,
    c=colors1,
    s=sizes1,
    alpha=0.6,
    edgecolors="w",
    linewidth=0.5,
)
ax1.set_title(titles[0])
ax1.set_xlabel(xlabels[0])
ax1.set_ylabel(ylabels[0])
ax1.invert_xaxis()
for i, txt in enumerate(psychologists):
    ax1.annotate(
        txt,
        (years_active_since_2023[i], citation_scores[i]),
        xytext=(-10, 10),
        textcoords="offset points",
    )
ax1.set_xlim([130, 50])
ax1.set_ylim([50, 100])

# Second subplot
scatter2 = ax2.scatter(
    contributions,
    influence_scores,
    c=colors2,
    s=sizes2,
    alpha=0.6,
    edgecolors="w",
    linewidth=0.5,
)
ax2.set_title(titles[1])
ax2.set_xlabel(xlabels[1])
ax2.set_ylabel(ylabels[1])
for i, txt in enumerate(psychologists):
    ax2.annotate(
        txt,
        (contributions[i], influence_scores[i]),
        xytext=(-10, 10),
        textcoords="offset points",
    )
ax2.set_xlim([40, 100])
ax2.set_ylim([50, 100])

# Add legends
legend1 = [
    plt.Line2D(
        [0],
        [0],
        marker="o",
        color="w",
        markerfacecolor=color,
        markersize=10,
        label=name,
    )
    for name, color in zip(psychologists, colors1)
]
ax1.legend(
    handles=legend1, title="Psychologists", bbox_to_anchor=(1.05, 1), loc="upper left"
)
legend2 = [
    plt.Line2D(
        [0],
        [0],
        marker="o",
        color="w",
        markerfacecolor=color,
        markersize=10,
        label=name,
    )
    for name, color in zip(psychologists, colors2)
]
ax2.legend(
    handles=legend2, title="Psychologists", bbox_to_anchor=(1.05, 1), loc="upper left"
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig("scatter_68.pdf", bbox_inches="tight")
