
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for plotting
crop_yield = [
    3.2,
    4.1,
    2.9,
    5.6,
    3.4,
    6.2,
    2.5,
    4.8,
]  # Crop yield in tons per hectare for different crops
water_usage = [
    400,
    500,
    300,
    550,
    420,
    600,
    280,
    520,
]  # Corresponding water usage in mm
crops = [
    "Wheat",
    "Corn",
    "Barley",
    "Rice",
    "Soybean",
    "Cotton",
    "Oats",
    "Sorghum",
]
xlabel = "Crop Yield (tons/ha)"
ylabel = "Water Usage (mm)"
legend_title = "Crop Type"
title = "Crop Yield vs. Water Usage"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(10, 6))

colors = [
    "skyblue",
    "lightcoral",
    "limegreen",
    "gold",
    "orange",
    "deeppink",
    "violet",
    "cyan",
]  # Colors representing different crops
markers = [
    "o",
    "^",
    "s",
    "P",
    "D",
    "X",
    "*",
    "H",
]  # Different markers for each crop

# Plot each point with corresponding color and marker
for i, (yield_rate, water, color, marker) in enumerate(
    zip(crop_yield, water_usage, colors, markers)
):
    ax.scatter(
        yield_rate,
        water,
        color=color,
        marker=marker,
        label=crops[i],
        s=100,
        edgecolors="w",
    )

# Set labels and title
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_title(title, fontsize=14)

# Create legend
legend = ax.legend(
    title=legend_title, bbox_to_anchor=(1.05, 1), loc="upper left", fontsize=10
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to make room for the legend
plt.tight_layout()
plt.savefig("scatter_71.pdf", bbox_inches="tight")
