
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for the scatter plot representing inflation rate and unemployment rate
x = np.array([1.2, 2.8, 3.5, 4.1, 0.6, 6.3, 1.7, 2.1, 2.9, 5.5, 6.1, 4.7, 3.3])
y = np.array([3.5, 4.0, 3.8, 4.2, 2.5, 7.0, 3.0, 3.6, 4.1, 6.5, 7.1, 5.8, 4.0])
xlabel = "Inflation Rate (%)"
ylabel = "Unemployment Rate (%)"
title = "Inflation vs Unemployment"
annotate_text = "High Inflation, High Unemployment"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(8, 6))  # Adjust the figure size for better detail
colors = np.linspace(0, 1, len(x))  # Create a color gradient based on the number of points
plt.scatter(x, y, c=colors, cmap="plasma", s=100, edgecolor="k", alpha=0.7, marker="o")
plt.grid(True, linestyle="--", linewidth=0.7)
plt.xlabel(xlabel, fontsize=12)
plt.ylabel(ylabel, fontsize=12)
plt.title(title, fontsize=15)
plt.colorbar(label="Color Intensity")
plt.annotate(
    annotate_text,
    xy=(6.3, 7.0),
    xytext=(4.0, 6.0),
    arrowprops=dict(facecolor="black", shrink=0.05),
    fontsize=10,
)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("scatter_80.pdf", bbox_inches="tight")
